/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.jackson.types;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import java.math.BigInteger;
import java.util.Calendar;
import javax.inject.Singleton;
import javax.ws.rs.ext.Provider;
import net.krotscheck.kangaroo.common.jackson.types.Base16BigIntegerDeserializer;
import net.krotscheck.kangaroo.common.jackson.types.Base16BigIntegerSerializer;
import net.krotscheck.kangaroo.common.jackson.types.UnixTimestampDeserializer;
import net.krotscheck.kangaroo.common.jackson.types.UnixTimestampSerializer;

@Provider
@Singleton
public final class KangarooCustomTypesModule
extends Module {
    private final String name = ((Object)((Object)this)).getClass().getSimpleName();
    private final Version version = Version.unknownVersion();

    public String getModuleName() {
        return this.name;
    }

    public Version version() {
        return this.version;
    }

    public void setupModule(Module.SetupContext context) {
        SimpleDeserializers des = new SimpleDeserializers();
        des.addDeserializer(BigInteger.class, (JsonDeserializer)new Base16BigIntegerDeserializer());
        des.addDeserializer(Calendar.class, (JsonDeserializer)new UnixTimestampDeserializer());
        SimpleSerializers ser = new SimpleSerializers();
        ser.addSerializer(BigInteger.class, (JsonSerializer)new Base16BigIntegerSerializer());
        ser.addSerializer(Calendar.class, (JsonSerializer)new UnixTimestampSerializer());
        context.addDeserializers((Deserializers)des);
        context.addSerializers((Serializers)ser);
    }
}

