/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.swagger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.commons.io.IOUtils;

@Path(value="/")
@Singleton
public final class SwaggerUIService {
    private final List<String> files = new ArrayList<String>();
    private final ClassLoader classLoader = this.getClass().getClassLoader();

    public SwaggerUIService() throws IOException {
        String line;
        ClassLoader classLoader = SwaggerUIService.class.getClassLoader();
        InputStream dir = classLoader.getResourceAsStream("swagger");
        BufferedReader in = new BufferedReader(new InputStreamReader(dir));
        while ((line = in.readLine()) != null) {
            this.files.add(line);
        }
        IOUtils.closeQuietly((InputStream)dir);
    }

    @GET
    public InputStream getFile() {
        return this.specificFile("index.html");
    }

    @GET
    @Path(value="{path: [^./]+\\.(html|css|js|png)}")
    public InputStream specificFile(@PathParam(value="path") String path) {
        if (!this.files.contains(path)) {
            throw new NotFoundException();
        }
        String resourcePath = String.format("swagger/%s", path);
        return this.classLoader.getResourceAsStream(resourcePath);
    }
}

