/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;

public final class KangarooErrorPageGenerator
implements ErrorPageGenerator {
    private static final ObjectMapper MAPPER = new ObjectMapperFactory().get();

    public ObjectMapper getMapper() {
        return MAPPER;
    }

    public String generate(Request request, int status, String reasonPhrase, String description, Throwable exception) {
        Response r = request.getResponse();
        r.setContentType("application/json");
        ErrorResponseBuilder.ErrorResponse body = ErrorResponseBuilder.from(Response.Status.fromStatusCode((int)status), description).buildEntity();
        try {
            return this.getMapper().writeValueAsString((Object)body);
        }
        catch (JsonProcessingException jpe) {
            return "{\"error\":\"internal_server_error\",\"error_description\":\"Internal Server Error\"}";
        }
    }
}

