/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server.keystore;

import java.io.FileInputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import net.krotscheck.kangaroo.server.keystore.IKeystoreProvider;

public final class FSKeystoreProvider
implements IKeystoreProvider {
    private KeyStore keyStore;
    private String keystorePath;
    private String keystorePass;
    private String keystoreType;

    public FSKeystoreProvider(String keystorePath, String keystorePass, String keystoreType) {
        this.keystorePath = keystorePath;
        this.keystorePass = keystorePass;
        this.keystoreType = keystoreType;
    }

    @Override
    public KeyStore getKeyStore() {
        if (this.keyStore == null) {
            try {
                this.keyStore = KeyStore.getInstance(this.keystoreType);
                FileInputStream fis = new FileInputStream(this.keystorePath);
                this.keyStore.load(fis, this.keystorePass.toCharArray());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.keyStore;
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        try {
            this.getKeyStore().store(outputStream, this.keystorePass.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

