/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.util;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtil {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    private HttpUtil() {
    }

    public static String authHeaderBasic(String login, String password) {
        if (Strings.isNullOrEmpty((String)login) || Strings.isNullOrEmpty((String)password)) {
            return "";
        }
        byte[] bytesEncoded = Base64.encodeBase64((byte[])(login + ":" + password).getBytes(UTF8));
        return "Basic " + new String(bytesEncoded, UTF8);
    }

    public static String authHeaderBasic(BigInteger login, String password) {
        return HttpUtil.authHeaderBasic(IdUtil.toString(login), password);
    }

    public static String authHeaderBearer(BigInteger token) {
        return HttpUtil.authHeaderBearer(IdUtil.toString(token));
    }

    public static String authHeaderBearer(String token) {
        if (Strings.isNullOrEmpty((String)token)) {
            return "";
        }
        return String.format("Bearer %s", token);
    }

    public static MultivaluedMap<String, String> parseQueryParams(URI uri) {
        if (uri == null) {
            return new MultivaluedStringMap();
        }
        return HttpUtil.parseQueryParams(uri.getRawQuery());
    }

    public static MultivaluedMap<String, String> parseQueryParams(String query) {
        MultivaluedStringMap results = new MultivaluedStringMap();
        List params = URLEncodedUtils.parse((String)query, (Charset)Charset.forName("ISO-8859-1"));
        for (NameValuePair pair : params) {
            results.add((Object)pair.getName(), (Object)pair.getValue());
        }
        return results;
    }

    public static MultivaluedMap<String, String> parseBodyParams(Response response) {
        try {
            Charset charset = Charset.forName("UTF-8");
            InputStream stream = (InputStream)response.getEntity();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)stream, (Writer)writer, (Charset)charset);
            return HttpUtil.parseQueryParams(writer.toString());
        }
        catch (IOException ioe) {
            logger.error("Could not decode params in stream.", (Throwable)ioe);
            return new MultivaluedHashMap();
        }
    }
}

