/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.config;

import java.util.Properties;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.config.ConfigurationBinder;
import net.krotscheck.kangaroo.common.config.ConfigurationFeature;
import net.krotscheck.kangaroo.common.config.SystemConfiguration;
import net.krotscheck.kangaroo.test.jersey.KangarooJerseyTest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;

public final class ConfigurationBinderTest
extends KangarooJerseyTest {
    @Override
    protected ResourceConfig createApplication() {
        Properties properties = new Properties();
        properties.setProperty("foo", "bar");
        MapConfiguration mapConfig = new MapConfiguration(properties);
        ResourceConfig a = new ResourceConfig();
        a.register(ConfigurationFeature.class);
        a.register((Object)new ConfigurationBinder((Configuration)mapConfig));
        a.register(MockService.class);
        return a;
    }

    @Test
    public void testBoundExternalValue() {
        String response = (String)this.target("/foo").request().get(String.class);
        Assert.assertEquals((Object)"bar", (Object)response);
    }

    @Path(value="/")
    public static final class MockService {
        private SystemConfiguration config;

        @Inject
        public MockService(SystemConfiguration config) {
            this.config = config;
        }

        @GET
        @Path(value="{key}")
        @Produces(value={"application/json"})
        public Response getSpecificValue(@PathParam(value="key") String key) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.config.getString(key)).build();
        }
    }
}

