/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.config;

import java.util.Collections;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import net.krotscheck.kangaroo.common.config.SystemConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.junit.Assert;
import org.junit.Test;

public final class SystemConfigurationTest {
    @Test
    public void testConfigurationDefaults() {
        SystemConfiguration config = new SystemConfiguration(Collections.emptyList());
        Assert.assertEquals((Object)TimeZone.getTimeZone("UTC"), (Object)config.getTimezone());
        org.apache.commons.configuration.SystemConfiguration c = new org.apache.commons.configuration.SystemConfiguration();
        c.getKeys().forEachRemaining(s -> Assert.assertTrue((String)s, (boolean)config.containsKey(s)));
    }

    @Test
    public void testConfigurationInjection() {
        Properties properties = new Properties();
        properties.setProperty("foo", "bar");
        MapConfiguration mapConfig = new MapConfiguration(properties);
        SystemConfiguration config = new SystemConfiguration(Collections.singletonList(mapConfig));
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> Assert.assertEquals((Object)v, (Object)config.getString(k.toString()))));
    }
}

