/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.cors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import net.krotscheck.kangaroo.common.cors.AllowedHeaders;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;
import org.junit.Assert;
import org.junit.Test;

public final class AllowedHeadersTest {
    @Test
    public void testBinder() throws Exception {
        InjectionManager injector = Injections.createInjectionManager();
        AllowedHeaders b1 = new AllowedHeaders(new String[]{"Test1", "Test2"});
        AllowedHeaders b2 = new AllowedHeaders(new String[]{"Test3", "Test4"});
        injector.register((Binder)b1);
        injector.register((Binder)b2);
        Injectee testInjectee = new Injectee();
        injector.inject((Object)testInjectee);
        ArrayList values = Lists.newArrayList(testInjectee.getValues());
        Assert.assertTrue((boolean)values.contains("Test1"));
        Assert.assertTrue((boolean)values.contains("Test2"));
        Assert.assertTrue((boolean)values.contains("Test3"));
        Assert.assertTrue((boolean)values.contains("Test4"));
        Assert.assertEquals((long)4L, (long)values.size());
        injector.shutdown();
    }

    public static final class Injectee {
        private Iterable<String> values;

        public Iterable<String> getValues() {
            return this.values;
        }

        @Inject
        public void setValues(@Named(value="CORS_ALLOWED_HEADERS") Iterable<String> values) {
            this.values = values;
        }
    }
}

