/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.cors;

import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.cors.CORSFeature;
import net.krotscheck.kangaroo.common.cors.TestCORSValidator;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;

public final class CORSFeatureTest
extends ContainerTest {
    private static final GenericType<List<String>> LIST_TYPE = new GenericType<List<String>>(){};

    @Override
    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register((Object)new TestCORSValidator.Binder());
        a.register(CORSFeature.class);
        a.register(MockService.class);
        return a;
    }

    @Test
    public void testAllowedHeaders() {
        Response response = this.target("/allowed_headers").request().get();
        List results = (List)response.readEntity(LIST_TYPE);
        Assert.assertTrue((boolean)results.contains("Accept"));
        Assert.assertTrue((boolean)results.contains("Accept-Language"));
        Assert.assertTrue((boolean)results.contains("Content-Language"));
        Assert.assertTrue((boolean)results.contains("Authorization"));
        Assert.assertTrue((boolean)results.contains("Content-Type"));
        Assert.assertTrue((boolean)results.contains("Origin"));
        Assert.assertTrue((boolean)results.contains("X-Requested-With"));
    }

    @Test
    public void testAllowedMethods() {
        Response response = this.target("/allowed_methods").request().get();
        List results = (List)response.readEntity(LIST_TYPE);
        Assert.assertTrue((boolean)results.contains("GET"));
        Assert.assertTrue((boolean)results.contains("PUT"));
        Assert.assertTrue((boolean)results.contains("POST"));
        Assert.assertTrue((boolean)results.contains("DELETE"));
        Assert.assertTrue((boolean)results.contains("OPTIONS"));
    }

    @Test
    public void testExposedHeaders() {
        Response response = this.target("/exposed_headers").request().get();
        List results = (List)response.readEntity(LIST_TYPE);
        Assert.assertTrue((boolean)results.contains("Location"));
        Assert.assertTrue((boolean)results.contains("WWW-Authenticate"));
        Assert.assertTrue((boolean)results.contains("Cache-Control"));
        Assert.assertTrue((boolean)results.contains("Content-Language"));
        Assert.assertTrue((boolean)results.contains("Content-Type"));
        Assert.assertTrue((boolean)results.contains("Expires"));
        Assert.assertTrue((boolean)results.contains("Last-Modified"));
        Assert.assertTrue((boolean)results.contains("Pragma"));
    }

    @Path(value="/")
    public static final class MockService {
        private List<String> allowedHeaders;
        private List<String> exposedHeaders;
        private List<String> allowedMethods;

        @Inject
        public MockService(@Named(value="CORS_ALLOWED_HEADERS") Iterable<String> allowedHeaders, @Named(value="CORS_EXPOSED_HEADERS") Iterable<String> exposedHeaders, @Named(value="CORS_ALLOWED_METHODS") Iterable<String> allowedMethods) {
            this.allowedHeaders = Lists.newArrayList(allowedHeaders);
            this.exposedHeaders = Lists.newArrayList(exposedHeaders);
            this.allowedMethods = Lists.newArrayList(allowedMethods);
        }

        @Path(value="/allowed_methods")
        @GET
        @Produces(value={"application/json"})
        public Response getAllowedMethods() {
            return Response.status((int)200).entity(this.allowedMethods).build();
        }

        @Path(value="/exposed_headers")
        @GET
        @Produces(value={"application/json"})
        public Response getExposedHeaders() {
            return Response.status((int)200).entity(this.exposedHeaders).build();
        }

        @Path(value="/allowed_headers")
        @GET
        @Produces(value={"application/json"})
        public Response getAllowedHeaders() {
            return Response.status((int)200).entity(this.allowedHeaders).build();
        }
    }
}

