/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.cors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.cors.AllowedHeaders;
import net.krotscheck.kangaroo.common.cors.AllowedMethods;
import net.krotscheck.kangaroo.common.cors.CORSFilter;
import net.krotscheck.kangaroo.common.cors.ExposedHeaders;
import net.krotscheck.kangaroo.common.cors.TestCORSValidator;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.server.ResourceConfig;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;

public final class CORSFilterTest
extends ContainerTest {
    @Override
    protected ResourceConfig createApplication() {
        ResourceConfig config = new ResourceConfig();
        config.register(CORSFilter.class);
        config.register((Object)new AllowedHeaders(new String[]{"One", "Two", "Three", ""}));
        config.register((Object)new ExposedHeaders(new String[]{"One", "Two", "Three", ""}));
        config.register((Object)new AllowedMethods(new String[]{"GET", "OPTIONS", ""}));
        config.register((Object)new TestCORSValidator.Binder());
        config.register(MockService.class);
        return config;
    }

    @Test
    public void testBinder() throws Exception {
        InjectionManager injector = Injections.createInjectionManager();
        injector.register((Binder)new TestCORSValidator.Binder());
        injector.register((Binder)new CORSFilter.Binder());
        List crfList = injector.getAllInstances(ContainerResponseFilter.class);
        Assert.assertEquals((long)1L, (long)crfList.size());
        ContainerResponseFilter crf2 = (ContainerResponseFilter)injector.getInstance(ContainerResponseFilter.class);
        Assert.assertSame((Object)crf2, crfList.get(0));
        injector.shutdown();
    }

    private void validateContainsHeaders(MultivaluedMap<String, Object> expected, MultivaluedMap<String, Object> received) {
        expected.forEach((key, values) -> {
            Assert.assertTrue((boolean)received.containsKey(key));
            Assert.assertThat((Object)received.get(key), (Matcher)IsCollectionContaining.hasItems((Object[])values.toArray()));
        });
    }

    @Test
    public void testRegularWithNoOrigin() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.add((Object)"One", (Object)"One");
        reqHeaders.add((Object)"Two", (Object)"Two");
        reqHeaders.add((Object)"Three", (Object)"Three");
        Response r = this.target("/").request().headers((MultivaluedMap)reqHeaders).build("GET").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Expose-Headers", "Access-Control-Max-Age"));
        Assert.assertEquals((long)200L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    private void validateOmitHeaders(List<String> omittedHeaders, MultivaluedMap<String, Object> received) {
        long foundHeaders = received.keySet().stream().filter(omittedHeaders::contains).count();
        Assert.assertEquals((long)0L, (long)foundHeaders);
    }

    @Test
    public void testRegularWithUnregisteredOrigin() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.add((Object)"Origin", (Object)"http://invalid.example.com");
        reqHeaders.add((Object)"One", (Object)"One");
        reqHeaders.add((Object)"Two", (Object)"Two");
        reqHeaders.add((Object)"Three", (Object)"Three");
        Response r = this.target("/").request().headers((MultivaluedMap)reqHeaders).build("GET").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Expose-Headers", "Access-Control-Max-Age"));
        Assert.assertEquals((long)200L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    @Test
    public void testRegularWithInvalidMethod() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.add((Object)"Origin", (Object)"http://valid.example.com");
        reqHeaders.add((Object)"One", (Object)"One");
        reqHeaders.add((Object)"Two", (Object)"Two");
        reqHeaders.add((Object)"Three", (Object)"Three");
        Response r = this.target("/").request().headers((MultivaluedMap)reqHeaders).build("POST").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Expose-Headers", "Access-Control-Max-Age"));
        Assert.assertEquals((long)200L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    @Test
    public void testRegularWithValidOrigin() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.add((Object)"Origin", (Object)"http://valid.example.com");
        reqHeaders.add((Object)"One", (Object)"One");
        reqHeaders.add((Object)"Two", (Object)"Two");
        reqHeaders.add((Object)"Three", (Object)"Three");
        Response r = this.target("/").request().headers((MultivaluedMap)reqHeaders).build("GET").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        expHeaders.add((Object)"Access-Control-Expose-Headers", (Object)"one");
        expHeaders.add((Object)"Access-Control-Expose-Headers", (Object)"two");
        expHeaders.add((Object)"Access-Control-Expose-Headers", (Object)"three");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Max-Age"));
        Assert.assertEquals((long)200L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    @Test
    public void testRegularWithValidOriginAndUnregisteredHeaders() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.add((Object)"Origin", (Object)"http://valid.example.com");
        reqHeaders.add((Object)"One", (Object)"One");
        reqHeaders.add((Object)"Three", (Object)"Three");
        reqHeaders.add((Object)"Four", (Object)"Four");
        reqHeaders.add((Object)"Five", (Object)"Five");
        Response r = this.target("/").request().headers((MultivaluedMap)reqHeaders).build("GET").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        expHeaders.add((Object)"Access-Control-Expose-Headers", (Object)"one");
        expHeaders.add((Object)"Access-Control-Expose-Headers", (Object)"three");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Max-Age"));
        Assert.assertEquals((long)200L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    @Test
    public void testPreflightWithNoOrigin() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.addAll((Object)"Access-Control-Request-Method", new Object[]{"GET"});
        reqHeaders.addAll((Object)"Access-Control-Request-Headers", new Object[]{"One", "Two", "Three"});
        Response r = this.target("/any").request().headers((MultivaluedMap)reqHeaders).build("OPTIONS").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Expose-Headers", "Access-Control-Max-Age"));
        Assert.assertEquals((long)404L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    @Test
    public void testPreflightWithInvalidOrigin() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.addAll((Object)"Origin", new Object[]{"http://invalid.example.com"});
        reqHeaders.addAll((Object)"Access-Control-Request-Method", new Object[]{"GET"});
        reqHeaders.addAll((Object)"Access-Control-Request-Headers", new Object[]{"One", "Two", "Three"});
        Response r = this.target("/any").request().headers((MultivaluedMap)reqHeaders).build("OPTIONS").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Expose-Headers", "Access-Control-Max-Age"));
        Assert.assertEquals((long)404L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    @Test
    public void testPreflightWithNoMethod() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.addAll((Object)"Origin", new Object[]{"http://valid.example.com"});
        reqHeaders.addAll((Object)"Access-Control-Request-Headers", new Object[]{"One", "Two", "Three"});
        Response r = this.target("/any").request().headers((MultivaluedMap)reqHeaders).build("OPTIONS").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Expose-Headers", "Access-Control-Max-Age"));
        Assert.assertEquals((long)200L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    @Test
    public void testPreflightWithInvalidMethod() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.addAll((Object)"Origin", new Object[]{"http://valid.example.com"});
        reqHeaders.addAll((Object)"Access-Control-Request-Method", new Object[]{"POST"});
        reqHeaders.addAll((Object)"Access-Control-Request-Headers", new Object[]{"One", "Two", "Three"});
        Response r = this.target("/any").request().headers((MultivaluedMap)reqHeaders).build("OPTIONS").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Expose-Headers", "Access-Control-Max-Age"));
        Assert.assertEquals((long)200L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    @Test
    public void testPreflightWithInvalidHeaders() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.addAll((Object)"Origin", new Object[]{"http://valid.example.com"});
        reqHeaders.addAll((Object)"Access-Control-Request-Method", new Object[]{"GET"});
        reqHeaders.addAll((Object)"Access-Control-Request-Headers", new Object[]{"Four", "Five", "Six"});
        Response r = this.target("/any").request().headers((MultivaluedMap)reqHeaders).build("OPTIONS").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        expHeaders.add((Object)"Vary", (Object)"Access-Control-Request-Headers");
        expHeaders.add((Object)"Vary", (Object)"Access-Control-Request-Method");
        expHeaders.add((Object)"Access-Control-Allow-Methods", (Object)"GET");
        expHeaders.add((Object)"Access-Control-Allow-Origin", (Object)"http://valid.example.com");
        expHeaders.add((Object)"Access-Control-Allow-Credentials", (Object)"true");
        expHeaders.add((Object)"Access-Control-Max-Age", (Object)"300");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Allow-Headers", "Access-Control-Expose-Headers"));
        Assert.assertEquals((long)200L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    @Test
    public void testValidPreflight() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.addAll((Object)"Origin", new Object[]{"http://valid.example.com"});
        reqHeaders.addAll((Object)"Access-Control-Request-Method", new Object[]{"GET"});
        reqHeaders.addAll((Object)"Access-Control-Request-Headers", new Object[]{"One", "Two", "Three"});
        Response r = this.target("/any").request().headers((MultivaluedMap)reqHeaders).build("OPTIONS").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        expHeaders.add((Object)"Vary", (Object)"Access-Control-Request-Headers");
        expHeaders.add((Object)"Vary", (Object)"Access-Control-Request-Method");
        expHeaders.add((Object)"Access-Control-Allow-Methods", (Object)"GET");
        expHeaders.add((Object)"Access-Control-Allow-Origin", (Object)"http://valid.example.com");
        expHeaders.add((Object)"Access-Control-Allow-Credentials", (Object)"true");
        expHeaders.add((Object)"Access-Control-Allow-Headers", (Object)"one");
        expHeaders.add((Object)"Access-Control-Allow-Headers", (Object)"two");
        expHeaders.add((Object)"Access-Control-Allow-Headers", (Object)"three");
        expHeaders.add((Object)"Access-Control-Max-Age", (Object)"300");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Expose-Headers"));
        Assert.assertEquals((long)200L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    @Test
    public void testValidPreflightExistingResource() {
        MultivaluedHashMap reqHeaders = new MultivaluedHashMap();
        reqHeaders.addAll((Object)"Origin", new Object[]{"http://valid.example.com"});
        reqHeaders.addAll((Object)"Access-Control-Request-Method", new Object[]{"GET"});
        reqHeaders.addAll((Object)"Access-Control-Request-Headers", new Object[]{"One", "Two", "Three"});
        Response r = this.target("/").request().headers((MultivaluedMap)reqHeaders).build("OPTIONS").invoke();
        MultivaluedHashMap expHeaders = new MultivaluedHashMap();
        expHeaders.add((Object)"Vary", (Object)"Origin");
        expHeaders.add((Object)"Vary", (Object)"Access-Control-Request-Headers");
        expHeaders.add((Object)"Vary", (Object)"Access-Control-Request-Method");
        expHeaders.add((Object)"Access-Control-Allow-Methods", (Object)"GET");
        expHeaders.add((Object)"Access-Control-Allow-Origin", (Object)"http://valid.example.com");
        expHeaders.add((Object)"Access-Control-Allow-Credentials", (Object)"true");
        expHeaders.add((Object)"Access-Control-Allow-Headers", (Object)"one");
        expHeaders.add((Object)"Access-Control-Allow-Headers", (Object)"two");
        expHeaders.add((Object)"Access-Control-Allow-Headers", (Object)"three");
        expHeaders.add((Object)"Access-Control-Max-Age", (Object)"300");
        expHeaders.add((Object)"Test", (Object)"One");
        ArrayList<String> omittedHeaders = new ArrayList<String>();
        omittedHeaders.addAll(Arrays.asList("Access-Control-Expose-Headers"));
        Assert.assertEquals((long)200L, (long)r.getStatus());
        this.validateContainsHeaders((MultivaluedMap<String, Object>)expHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
        this.validateOmitHeaders(omittedHeaders, (MultivaluedMap<String, Object>)r.getHeaders());
    }

    @Path(value="/")
    public static final class MockService {
        @OPTIONS
        public Response handleOptions() {
            return Response.status((Response.Status)Response.Status.OK).header("Test", (Object)"One").build();
        }

        @GET
        @Produces(value={"application/json"})
        public Response handleGet() {
            return Response.status((Response.Status)Response.Status.OK).header("One", (Object)"One").header("Two", (Object)"Two").header("Three", (Object)"Three").header("Four", (Object)"Four").build();
        }

        @POST
        @Produces(value={"application/json"})
        public Response handlePost() {
            return Response.status((Response.Status)Response.Status.OK).header("One", (Object)"One").header("Two", (Object)"Two").header("Three", (Object)"Three").header("Four", (Object)"Four").build();
        }
    }
}

