/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.exception;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Iterator;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import net.krotscheck.kangaroo.common.exception.KangarooExceptionTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class ErrorResponseBuilderTest {
    @Test
    public void testFromHttpStatusCode() {
        Response r = ErrorResponseBuilder.from((Response.Status)Response.Status.NOT_FOUND).build();
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.NOT_FOUND, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"Not Found", (Object)er.getErrorDescription());
        Assert.assertEquals((Object)"not_found", (Object)er.getError());
    }

    @Test
    public void testFromStatusAndMessage() {
        Response r = ErrorResponseBuilder.from((Response.Status)Response.Status.NOT_FOUND, (String)"message").build();
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.NOT_FOUND, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"message", (Object)er.getErrorDescription());
        Assert.assertEquals((Object)"not_found", (Object)er.getError());
    }

    @Test
    public void testFromStatusCodeAndMessage() {
        Response r = ErrorResponseBuilder.from((Response.Status)Response.Status.NOT_FOUND, (String)"message", (String)"test_code").build();
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.NOT_FOUND, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"message", (Object)er.getErrorDescription());
        Assert.assertEquals((Object)"test_code", (Object)er.getError());
    }

    @Test
    public void testFromJsonParseException() {
        JsonParseException e = new JsonParseException("foo", (JsonLocation)Mockito.mock(JsonLocation.class));
        Response r = ErrorResponseBuilder.from((JsonParseException)e).build();
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)er.getHttpStatus());
        Assert.assertTrue((er.getErrorDescription().indexOf("foo") > -1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"bad_request", (Object)er.getError());
    }

    @Test
    public void testFromKangarooException() {
        KangarooExceptionTest.TestError e = new KangarooExceptionTest.TestError();
        Response r = ErrorResponseBuilder.from((KangarooException)e).build();
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"Test Error", (Object)er.getErrorDescription());
        Assert.assertEquals((Object)"test_error", (Object)er.getError());
    }

    @Test
    public void testFromWebApplicationException() {
        WebApplicationException e = new WebApplicationException();
        Response r = ErrorResponseBuilder.from((WebApplicationException)e).build();
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.INTERNAL_SERVER_ERROR, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"HTTP 500 Internal Server Error", (Object)er.getErrorDescription());
        Assert.assertEquals((Object)"internal_server_error", (Object)er.getError());
    }

    @Test
    public void testFromConstraintException() {
        HashSet<ConstraintViolation> violations = new HashSet<ConstraintViolation>();
        ConstraintViolation m = (ConstraintViolation)Mockito.mock(ConstraintViolation.class);
        Mockito.when((Object)m.getMessage()).thenReturn((Object)"test 1");
        violations.add(m);
        ConstraintViolationException e = new ConstraintViolationException("message", violations);
        Response r = ErrorResponseBuilder.from((ConstraintViolationException)e).build();
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"test 1", (Object)er.getErrorDescription());
        Assert.assertEquals((Object)"bad_request", (Object)er.getError());
    }

    @Test
    public void testFromConstraintExceptionNoViolations() {
        HashSet violations = new HashSet();
        ConstraintViolationException e = new ConstraintViolationException("message", violations);
        Response r = ErrorResponseBuilder.from((ConstraintViolationException)e).build();
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.INTERNAL_SERVER_ERROR, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"Internal Server Error", (Object)er.getErrorDescription());
        Assert.assertEquals((Object)"internal_server_error", (Object)er.getError());
    }

    @Test
    public void testFromException() {
        Exception e = new Exception();
        Response r = ErrorResponseBuilder.from((Throwable)e).build();
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.INTERNAL_SERVER_ERROR, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"Internal Server Error", (Object)er.getErrorDescription());
        Assert.assertEquals((Object)"internal_server_error", (Object)er.getError());
    }

    @Test
    public void testEntityOnly() {
        Exception e = new Exception();
        ErrorResponseBuilder.ErrorResponse r = ErrorResponseBuilder.from((Throwable)e).buildEntity();
        Assert.assertEquals((Object)"Internal Server Error", (Object)r.getErrorDescription());
        Assert.assertEquals((Object)"internal_server_error", (Object)r.getError());
    }

    @Test
    public void testWithHeader() {
        Exception e = new Exception();
        Response r = ErrorResponseBuilder.from((Throwable)e).addHeader("test", "test").build();
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((Object)"test", (Object)r.getHeaderString("test"));
    }

    @Test
    public void testSerialization() throws Exception {
        Exception e = new Exception();
        Response r = ErrorResponseBuilder.from((Throwable)e).build();
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)er);
        JsonNode node = mapper.readTree(jsonString);
        int fieldCount = 0;
        Iterator nameIterator = node.fieldNames();
        while (nameIterator.hasNext()) {
            nameIterator.next();
            ++fieldCount;
        }
        Assert.assertEquals((long)2L, (long)fieldCount);
        Assert.assertEquals((Object)"Internal Server Error", (Object)node.get("error_description").asText());
        Assert.assertEquals((Object)"internal_server_error", (Object)node.get("error").asText());
    }
}

