/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.exception;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.exception.ExceptionFeature;
import net.krotscheck.kangaroo.test.jersey.KangarooJerseyTest;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class ExceptionFeatureTest
extends KangarooJerseyTest {
    @Override
    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register(ExceptionFeature.class);
        a.register(MockService.class);
        a.property("jersey.config.disableAutoDiscovery", (Object)true);
        a.register(JacksonJaxbJsonProvider.class);
        return a;
    }

    @Test
    public void testHttpStatusException() {
        Response r = this.target("/http").request().get();
        ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((long)404L, (long)r.getStatus());
        Assert.assertEquals((Object)"not_found", (Object)response.getError());
        Assert.assertEquals((Object)"HTTP 404 Not Found", (Object)response.getErrorDescription());
    }

    @Test
    public void testJerseyException() {
        Response r = this.target("/jersey").request().get();
        ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((long)500L, (long)r.getStatus());
        Assert.assertEquals((Object)"internal_server_error", (Object)response.getError());
        Assert.assertEquals((Object)"HTTP 500 Internal Server Error", (Object)response.getErrorDescription());
    }

    @Test
    public void testJsonException() {
        Response r = this.target("/json").request().get();
        ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((long)400L, (long)r.getStatus());
        Assert.assertEquals((Object)"bad_request", (Object)response.getError());
    }

    @Test
    public void testGenericException() {
        Response r = this.target("/generic").request().get();
        ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((long)500L, (long)r.getStatus());
        Assert.assertEquals((Object)"internal_server_error", (Object)response.getError());
        Assert.assertEquals((Object)"Internal Server Error", (Object)response.getErrorDescription());
    }

    @Path(value="/")
    public static final class MockService {
        @GET
        @Path(value="/http")
        @Produces(value={"application/json"})
        public Response http() {
            throw new NotFoundException();
        }

        @GET
        @Path(value="/jersey")
        @Produces(value={"application/json"})
        public Response jersey() {
            throw new WebApplicationException();
        }

        @GET
        @Path(value="/json")
        @Produces(value={"application/json"})
        public Response json() throws Exception {
            throw new JsonParseException("foo", (JsonLocation)Mockito.mock(JsonLocation.class));
        }

        @GET
        @Path(value="/generic")
        @Produces(value={"application/json"})
        public Response generic() throws Exception {
            throw new Exception("foo");
        }
    }
}

