/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.exception.mapper;

import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.exception.mapper.JerseyExceptionMapper;
import org.junit.Assert;
import org.junit.Test;

public final class JerseyExceptionMapperTest {
    @Test
    public void testToResponse() {
        JerseyExceptionMapper mapper = new JerseyExceptionMapper();
        WebApplicationException e = new WebApplicationException("test");
        Response r = mapper.toResponse(e);
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.INTERNAL_SERVER_ERROR, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"test", (Object)er.getErrorDescription());
    }

    @Test
    public void testNotFound() {
        JerseyExceptionMapper mapper = new JerseyExceptionMapper();
        NotFoundException e = new NotFoundException();
        Response r = mapper.toResponse((WebApplicationException)e);
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.NOT_FOUND, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"HTTP 404 Not Found", (Object)er.getErrorDescription());
        Assert.assertEquals((Object)"not_found", (Object)er.getError());
    }

    @Test
    public void testForbidden() {
        JerseyExceptionMapper mapper = new JerseyExceptionMapper();
        ForbiddenException e = new ForbiddenException();
        Response r = mapper.toResponse((WebApplicationException)e);
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.FORBIDDEN, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"HTTP 403 Forbidden", (Object)er.getErrorDescription());
        Assert.assertEquals((Object)"forbidden", (Object)er.getError());
    }
}

