/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.config;

import java.util.ArrayList;
import net.krotscheck.kangaroo.common.hibernate.config.HibernateConfiguration;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import org.apache.commons.configuration.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class HibernateConfigurationTest
extends DatabaseTest {
    private Configuration configOne;
    private Configuration configTwo;

    @Before
    public void setUp() {
        this.configOne = new HibernateConfiguration(this.getSessionFactory(), "one");
        this.configTwo = new HibernateConfiguration(this.getSessionFactory(), "two");
    }

    @After
    public void tearDown() {
        this.configOne.clear();
        this.configTwo.clear();
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.configOne.isEmpty());
        this.configOne.addProperty("key", (Object)"value");
        Assert.assertFalse((boolean)this.configOne.isEmpty());
    }

    @Test
    public void testKeys() {
        this.configOne.addProperty("key", (Object)"value");
        this.configOne.addProperty("lol", (Object)"cat");
        ArrayList keys = new ArrayList();
        this.configOne.getKeys().forEachRemaining(keys::add);
        Assert.assertTrue((boolean)keys.contains("key"));
        Assert.assertTrue((boolean)keys.contains("lol"));
        Assert.assertEquals((long)2L, (long)keys.size());
    }

    @Test
    public void testStoreAndRetrieve() {
        this.configOne.addProperty("key", (Object)"value");
        Assert.assertTrue((boolean)this.configOne.containsKey("key"));
        Assert.assertEquals((Object)"value", (Object)this.configOne.getString("key"));
        this.configOne.clearProperty("key");
        Assert.assertFalse((boolean)this.configOne.containsKey("key"));
    }

    @Test
    public void testMultipleInstances() {
        this.configOne.addProperty("key", (Object)"value");
        Assert.assertTrue((boolean)this.configOne.containsKey("key"));
        HibernateConfiguration configuration = new HibernateConfiguration(this.getSessionFactory(), "one");
        Assert.assertTrue((boolean)configuration.containsKey("key"));
    }

    @Test
    public void testNoGroupConflict() {
        this.configOne.addProperty("key", (Object)"value");
        Assert.assertTrue((boolean)this.configOne.containsKey("key"));
        Assert.assertFalse((boolean)this.configTwo.containsKey("key"));
        this.configTwo.addProperty("foo", (Object)"bar");
        Assert.assertFalse((boolean)this.configOne.containsKey("foo"));
        Assert.assertTrue((boolean)this.configTwo.containsKey("foo"));
    }
}

