/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.context;

import java.util.ArrayList;
import java.util.Set;
import net.krotscheck.kangaroo.common.hibernate.lifecycle.SearchIndexContainerLifecycleListener;
import net.krotscheck.kangaroo.common.hibernate.migration.DatabaseMigrationState;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class SearchIndexContainerLifecycleListenerTest
extends DatabaseTest {
    private MassIndexer mockIndexer;
    private SessionFactory mockFactory;
    private DatabaseMigrationState mockMigrationState;
    private Session testSession;
    private SearchIndexContainerLifecycleListener listener;
    private Container container;

    @Before
    public void setupTest() {
        this.mockFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        this.testSession = (Session)Mockito.spy((Object)this.getSession());
        Mockito.when((Object)this.mockFactory.openSession()).thenReturn((Object)this.testSession);
        this.mockIndexer = (MassIndexer)Mockito.mock(MassIndexer.class);
        this.mockMigrationState = (DatabaseMigrationState)Mockito.mock(DatabaseMigrationState.class);
        ((DatabaseMigrationState)Mockito.doReturn((Object)true).when((Object)this.mockMigrationState)).isSchemaChanged();
        FullTextSession mockFtSession = (FullTextSession)Mockito.mock(FullTextSession.class);
        Mockito.when((Object)mockFtSession.createIndexer(new Class[0])).thenReturn((Object)this.mockIndexer);
        this.listener = (SearchIndexContainerLifecycleListener)Mockito.spy((Object)new SearchIndexContainerLifecycleListener(this.mockFactory, this.mockMigrationState));
        this.container = (Container)Mockito.mock(Container.class);
        ((SearchIndexContainerLifecycleListener)Mockito.doReturn((Object)mockFtSession).when((Object)this.listener)).getFulltextSession((Session)ArgumentMatchers.any());
    }

    @Test
    public void testOnStartup() throws Exception {
        this.listener.onStartup(this.container);
        ((MassIndexer)Mockito.verify((Object)this.mockIndexer)).startAndWait();
        ((Session)Mockito.verify((Object)this.testSession)).close();
    }

    @Test
    public void testNoReindex() throws Exception {
        ((DatabaseMigrationState)Mockito.doReturn((Object)false).when((Object)this.mockMigrationState)).isSchemaChanged();
        this.listener.onStartup(this.container);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.container});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockIndexer});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockFactory});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.testSession});
    }

    @Test
    public void testInterruptedIndex() throws Exception {
        ((MassIndexer)Mockito.doThrow((Throwable[])new Throwable[]{new InterruptedException()}).when((Object)this.mockIndexer)).startAndWait();
        this.listener.onStartup(this.container);
        ((Session)Mockito.verify((Object)this.testSession)).close();
    }

    @Test
    public void testRandomException() throws Exception {
        ((MassIndexer)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.mockIndexer)).startAndWait();
        try {
            this.listener.onStartup(this.container);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((Object)e);
        }
        ((Session)Mockito.verify((Object)this.testSession)).close();
    }

    @Test
    public void testReload() throws Exception {
        this.listener.onReload(this.container);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.container});
    }

    @Test
    public void testShutdown() throws Exception {
        this.listener.onShutdown(this.container);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.container});
    }

    @Test
    public void testBuildIndexerPassthrough() throws Exception {
        this.listener = new SearchIndexContainerLifecycleListener(this.mockFactory, this.mockMigrationState);
        FullTextSession f = this.listener.getFulltextSession(this.testSession);
        Assert.assertNotNull((Object)f);
    }

    @Test
    public void testBinder() {
        SearchIndexContainerLifecycleListener.Binder b = new SearchIndexContainerLifecycleListener.Binder();
        ArrayList bindings = new ArrayList(b.getBindings());
        Assert.assertEquals((long)1L, (long)bindings.size());
        Binding binding = (Binding)bindings.get(0);
        Set types = binding.getContracts();
        Assert.assertTrue((boolean)types.contains(ContainerLifecycleListener.class));
    }
}

