/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.entity;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.util.Calendar;
import net.krotscheck.kangaroo.common.hibernate.entity.AbstractEntity;
import net.krotscheck.kangaroo.common.hibernate.entity.TestChildEntity;
import net.krotscheck.kangaroo.common.hibernate.entity.TestEntity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;

public final class AbstractEntityTest {
    private static final ObjectMapper MAPPER = new ObjectMapperFactory().get();

    @Test
    public void testSerialize() throws Exception {
        TestEntity a = new TestEntity();
        TestChildEntity c = new TestChildEntity();
        a.setId(IdUtil.next());
        c.setId(IdUtil.next());
        a.setChildEntity(c);
        String jsonString = MAPPER.writeValueAsString((Object)a);
        TestEntity b = (TestEntity)((Object)MAPPER.readValue(jsonString, TestEntity.class));
        Assert.assertEquals((Object)((Object)a), (Object)((Object)b));
        Assert.assertEquals((Object)a.getId(), (Object)b.getId());
        Assert.assertEquals((Object)((Object)a.getChildEntity()), (Object)((Object)b.getChildEntity()));
        Assert.assertEquals((Object)a.getChildEntity().getId(), (Object)b.getChildEntity().getId());
    }

    @Test
    public void testGetSetId() {
        BigInteger id = IdUtil.next();
        TestEntity a = new TestEntity();
        Assert.assertNull((Object)a.getId());
        a.setId(id);
        Assert.assertEquals((Object)id, (Object)a.getId());
    }

    @Test
    public void testGetSetCreatedDate() {
        TestEntity a = new TestEntity();
        Calendar d = Calendar.getInstance();
        Assert.assertNull((Object)a.getCreatedDate());
        a.setCreatedDate(d);
        Assert.assertEquals((Object)d, (Object)a.getCreatedDate());
        Assert.assertNotSame((Object)d, (Object)a.getCreatedDate());
    }

    @Test
    public void testGetSetModifiedDate() {
        TestEntity a = new TestEntity();
        Calendar d = Calendar.getInstance();
        Assert.assertNull((Object)a.getModifiedDate());
        a.setModifiedDate(d);
        Assert.assertEquals((Object)d, (Object)a.getModifiedDate());
        Assert.assertNotSame((Object)d, (Object)a.getModifiedDate());
    }

    @Test
    public void testEquality() {
        BigInteger id = IdUtil.next();
        TestEntity a = new TestEntity();
        a.setId(id);
        TestEntity b = new TestEntity();
        b.setId(id);
        TestEntity c = new TestEntity();
        c.setId(IdUtil.next());
        TestEntity d = new TestEntity();
        TestChildEntity e = new TestChildEntity();
        e.setId(IdUtil.next());
        Assert.assertTrue((boolean)a.equals((Object)a));
        Assert.assertFalse((boolean)a.equals(null));
        Assert.assertTrue((boolean)a.equals((Object)b));
        Assert.assertTrue((boolean)b.equals((Object)a));
        Assert.assertFalse((boolean)a.equals((Object)c));
        Assert.assertFalse((boolean)c.equals((Object)a));
        Assert.assertFalse((boolean)a.equals((Object)d));
        Assert.assertFalse((boolean)d.equals((Object)a));
        Assert.assertFalse((boolean)a.equals((Object)e));
        Assert.assertFalse((boolean)e.equals((Object)a));
    }

    @Test
    public void testHashCode() {
        BigInteger id = IdUtil.next();
        TestEntity a = new TestEntity();
        a.setId(id);
        TestEntity b = new TestEntity();
        b.setId(id);
        TestEntity c = new TestEntity();
        c.setId(IdUtil.next());
        TestEntity d = new TestEntity();
        TestChildEntity e = new TestChildEntity();
        e.setId(IdUtil.next());
        Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
        Assert.assertNotEquals((long)a.hashCode(), (long)c.hashCode());
        Assert.assertNotEquals((long)a.hashCode(), (long)d.hashCode());
        Assert.assertNotEquals((long)a.hashCode(), (long)e.hashCode());
    }

    @Test
    public void testToString() {
        TestEntity a = new TestEntity();
        a.setId(IdUtil.next());
        TestEntity b = new TestEntity();
        Assert.assertEquals((Object)String.format("net.krotscheck.kangaroo.common.hibernate.entity.TestEntity [id=%s]", IdUtil.toString((BigInteger)a.getId())), (Object)a.toString());
        Assert.assertEquals((Object)"net.krotscheck.kangaroo.common.hibernate.entity.TestEntity [id=null]", (Object)b.toString());
    }

    @Test
    public void testCloneable() throws CloneNotSupportedException {
        BigInteger id = IdUtil.next();
        TestEntity a = new TestEntity();
        a.setId(id);
        AbstractEntity b = (AbstractEntity)a.clone();
        Assert.assertEquals((Object)a.getId(), (Object)b.getId());
    }
}

