/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.factory;

import net.krotscheck.kangaroo.common.config.SystemConfiguration;
import net.krotscheck.kangaroo.common.hibernate.factory.FulltextSearchFactoryFactory;
import net.krotscheck.kangaroo.common.hibernate.factory.FulltextSessionFactory;
import net.krotscheck.kangaroo.common.hibernate.factory.HibernateServiceRegistryFactory;
import net.krotscheck.kangaroo.common.hibernate.factory.HibernateSessionFactory;
import net.krotscheck.kangaroo.common.hibernate.factory.HibernateSessionFactoryFactory;
import net.krotscheck.kangaroo.test.rule.DatabaseResource;
import net.krotscheck.kangaroo.test.rule.WorkingDirectoryRule;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class FulltextSearchFactoryFactoryTest {
    @ClassRule
    public static final TestRule DATABASE = new DatabaseResource();
    @Rule
    public final TestRule workingDirectory = new WorkingDirectoryRule();
    private InjectionManager injector;

    @Before
    public void setUp() {
        this.injector = Injections.createInjectionManager();
        this.injector.register((Binder)new SystemConfiguration.Binder());
        this.injector.register((Binder)new HibernateServiceRegistryFactory.Binder());
        this.injector.register((Binder)new HibernateSessionFactoryFactory.Binder());
        this.injector.register((Binder)new HibernateSessionFactory.Binder());
        this.injector.register((Binder)new FulltextSessionFactory.Binder());
        this.injector.register((Binder)new FulltextSearchFactoryFactory.Binder());
        this.injector.completeRegistration();
    }

    @After
    public void tearDown() {
        this.injector.shutdown();
        this.injector = null;
    }

    @Test
    public void testProvideDispose() {
        SessionFactory sessionFactory = (SessionFactory)this.injector.getInstance(SessionFactory.class);
        Session hibernateSession = sessionFactory.openSession();
        FullTextSession ftSession = Search.getFullTextSession((Session)hibernateSession);
        FulltextSearchFactoryFactory factory = new FulltextSearchFactoryFactory(ftSession);
        SearchFactory searchFactory = factory.get();
        Assert.assertNotNull((Object)searchFactory);
        if (hibernateSession.isOpen()) {
            hibernateSession.close();
        }
    }
}

