/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.factory;

import java.util.ArrayList;
import net.krotscheck.kangaroo.common.config.SystemConfiguration;
import net.krotscheck.kangaroo.common.hibernate.factory.HibernateServiceRegistryFactory;
import net.krotscheck.kangaroo.test.TestConfig;
import net.krotscheck.kangaroo.test.rule.DatabaseResource;
import net.krotscheck.kangaroo.test.rule.WorkingDirectoryRule;
import org.apache.commons.configuration.Configuration;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;
import org.hibernate.boot.MetadataSources;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.MariaDBDialect;
import org.hibernate.service.ServiceRegistry;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class HibernateServiceRegistryFactoryTest {
    @ClassRule
    public static final TestRule DATABASE = new DatabaseResource();
    @Rule
    public final TestRule workingDirectory = new WorkingDirectoryRule();

    @Test
    public void testProvideDispose() throws Exception {
        SystemConfiguration testConfig = new SystemConfiguration(new ArrayList());
        HibernateServiceRegistryFactory factory = new HibernateServiceRegistryFactory((Configuration)testConfig);
        ServiceRegistry serviceRegistry = factory.get();
        String dbDriver = TestConfig.getDbDriver();
        Dialect d = new MetadataSources(serviceRegistry).buildMetadata().getDatabase().getDialect();
        switch (dbDriver) {
            case "org.h2.Driver": {
                Assert.assertTrue((boolean)(d instanceof H2Dialect));
                break;
            }
            case "org.mariadb.jdbc.Driver": {
                Assert.assertTrue((boolean)(d instanceof MariaDBDialect));
                break;
            }
            default: {
                Assert.fail((String)String.format("Unrecognized driver: %s", dbDriver));
            }
        }
        factory.dispose(serviceRegistry);
    }

    @Test
    public void testBinder() throws ClassNotFoundException {
        InjectionManager injector = Injections.createInjectionManager();
        injector.register((Binder)new SystemConfiguration.Binder());
        injector.register((Binder)new HibernateServiceRegistryFactory.Binder());
        injector.completeRegistration();
        ServiceRegistry serviceRegistry = (ServiceRegistry)injector.getInstance(ServiceRegistry.class);
        Assert.assertNotNull((Object)serviceRegistry);
        String dbDriver = TestConfig.getDbDriver();
        Dialect d = new MetadataSources(serviceRegistry).buildMetadata().getDatabase().getDialect();
        switch (dbDriver) {
            case "org.h2.Driver": {
                Assert.assertTrue((boolean)(d instanceof H2Dialect));
                break;
            }
            case "org.mariadb.jdbc.Driver": {
                Assert.assertTrue((boolean)(d instanceof MariaDBDialect));
                break;
            }
            default: {
                Assert.fail((String)String.format("Unrecognized driver: %s", dbDriver));
            }
        }
        ServiceRegistry serviceRegistry2 = (ServiceRegistry)injector.getInstance(ServiceRegistry.class);
        Assert.assertSame((Object)serviceRegistry, (Object)serviceRegistry2);
        injector.shutdown();
    }
}

