/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.factory;

import net.krotscheck.kangaroo.common.config.SystemConfiguration;
import net.krotscheck.kangaroo.common.hibernate.factory.HibernateServiceRegistryFactory;
import net.krotscheck.kangaroo.common.hibernate.factory.HibernateSessionFactoryFactory;
import net.krotscheck.kangaroo.test.rule.DatabaseResource;
import net.krotscheck.kangaroo.test.rule.WorkingDirectoryRule;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.PerThread;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCommitDeleteEventListener;
import org.hibernate.event.spi.PostCommitInsertEventListener;
import org.hibernate.event.spi.PostCommitUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class HibernateSessionFactoryFactoryTest {
    @ClassRule
    public static final TestRule DATABASE = new DatabaseResource();
    @Rule
    public final TestRule workingDirectory = new WorkingDirectoryRule();
    private InjectionManager injector;

    @Before
    public void setUp() {
        this.injector = Injections.createInjectionManager();
        this.injector.register((Binder)new SystemConfiguration.Binder());
        this.injector.register((Binder)new HibernateServiceRegistryFactory.Binder());
        this.injector.register((Binder)new HibernateSessionFactoryFactory.Binder());
        this.injector.register((Binder)new TestEventListener.Binder());
        this.injector.completeRegistration();
    }

    @After
    public void tearDown() {
        this.injector.shutdown();
        this.injector = null;
    }

    @Test
    public void testProvideDispose() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.injector.getInstance(ServiceRegistry.class);
        HibernateSessionFactoryFactory factoryFactory = new HibernateSessionFactoryFactory(serviceRegistry, this.injector);
        SessionFactory factory = (SessionFactory)this.injector.getInstance(SessionFactory.class);
        Assert.assertFalse((boolean)factory.isClosed());
        Session session = factory.openSession();
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((boolean)session.isOpen());
        factoryFactory.dispose(factory);
        Assert.assertTrue((boolean)factory.isClosed());
        Assert.assertFalse((boolean)session.isOpen());
        factoryFactory.dispose(factory);
        factoryFactory.dispose(null);
    }

    @Test
    public void testBinder() {
        SessionFactory factoryFactory = (SessionFactory)this.injector.getInstance(SessionFactory.class);
        Assert.assertNotNull((Object)factoryFactory);
        Assert.assertFalse((boolean)factoryFactory.isClosed());
        SessionFactory factoryFactory2 = (SessionFactory)this.injector.getInstance(SessionFactory.class);
        Assert.assertSame((Object)factoryFactory, (Object)factoryFactory2);
    }

    @Test
    public void testEventInjection() {
        SessionFactory factoryFactory = (SessionFactory)this.injector.getInstance(SessionFactory.class);
        Assert.assertNotNull((Object)factoryFactory);
        ServiceRegistryImplementor serviceRegistry = ((SessionFactoryImpl)factoryFactory).getServiceRegistry();
        EventListenerRegistry eventRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        EventListenerGroup priGroup = eventRegistry.getEventListenerGroup(EventType.PRE_INSERT);
        this.assertContainsListener(priGroup);
        EventListenerGroup poiGroup = eventRegistry.getEventListenerGroup(EventType.POST_INSERT);
        this.assertContainsListener(poiGroup);
        EventListenerGroup pruGroup = eventRegistry.getEventListenerGroup(EventType.PRE_UPDATE);
        this.assertContainsListener(pruGroup);
        EventListenerGroup pouGroup = eventRegistry.getEventListenerGroup(EventType.POST_UPDATE);
        this.assertContainsListener(pouGroup);
        EventListenerGroup prdGroup = eventRegistry.getEventListenerGroup(EventType.PRE_DELETE);
        this.assertContainsListener(prdGroup);
        EventListenerGroup podGroup = eventRegistry.getEventListenerGroup(EventType.POST_DELETE);
        this.assertContainsListener(podGroup);
        EventListenerGroup pciGroup = eventRegistry.getEventListenerGroup(EventType.POST_COMMIT_INSERT);
        this.assertContainsListener(pciGroup);
        EventListenerGroup pcuGroup = eventRegistry.getEventListenerGroup(EventType.POST_COMMIT_UPDATE);
        this.assertContainsListener(pcuGroup);
        EventListenerGroup pcdGroup = eventRegistry.getEventListenerGroup(EventType.POST_COMMIT_DELETE);
        this.assertContainsListener(pcdGroup);
    }

    private void assertContainsListener(EventListenerGroup group) {
        for (Object listener : group.listeners()) {
            if (!(listener instanceof TestEventListener)) continue;
            return;
        }
        Assert.assertFalse((boolean)true);
    }

    public static final class TestEventListener
    implements PreInsertEventListener,
    PostInsertEventListener,
    PreUpdateEventListener,
    PostUpdateEventListener,
    PreDeleteEventListener,
    PostDeleteEventListener,
    PostCommitInsertEventListener,
    PostCommitUpdateEventListener,
    PostCommitDeleteEventListener {
        public void onPostDelete(PostDeleteEvent event) {
        }

        public void onPostInsert(PostInsertEvent event) {
        }

        public void onPostUpdate(PostUpdateEvent event) {
        }

        public boolean requiresPostCommitHanding(EntityPersister persister) {
            return false;
        }

        public boolean onPreDelete(PreDeleteEvent event) {
            return false;
        }

        public boolean onPreInsert(PreInsertEvent event) {
            return false;
        }

        public boolean onPreUpdate(PreUpdateEvent event) {
            return false;
        }

        public void onPostDeleteCommitFailed(PostDeleteEvent event) {
        }

        public void onPostInsertCommitFailed(PostInsertEvent event) {
        }

        public void onPostUpdateCommitFailed(PostUpdateEvent event) {
        }

        public static final class Binder
        extends AbstractBinder {
            protected void configure() {
                ((ClassBinding)((ClassBinding)((ClassBinding)((ClassBinding)((ClassBinding)((ClassBinding)((ClassBinding)((ClassBinding)((ClassBinding)this.bind(TestEventListener.class).to(PostDeleteEventListener.class)).to(PreDeleteEventListener.class)).to(PreInsertEventListener.class)).to(PostInsertEventListener.class)).to(PreUpdateEventListener.class)).to(PostUpdateEventListener.class)).to(PostCommitInsertEventListener.class)).to(PostCommitUpdateEventListener.class)).to(PostCommitDeleteEventListener.class)).in(PerThread.class);
            }
        }
    }
}

