/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.factory;

import net.krotscheck.kangaroo.common.config.SystemConfiguration;
import net.krotscheck.kangaroo.common.hibernate.factory.HibernateServiceRegistryFactory;
import net.krotscheck.kangaroo.common.hibernate.factory.HibernateSessionFactory;
import net.krotscheck.kangaroo.common.hibernate.factory.HibernateSessionFactoryFactory;
import net.krotscheck.kangaroo.test.rule.DatabaseResource;
import net.krotscheck.kangaroo.test.rule.WorkingDirectoryRule;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class HibernateSessionFactoryTest {
    @ClassRule
    public static final TestRule DATABASE = new DatabaseResource();
    @Rule
    public final TestRule workingDirectory = new WorkingDirectoryRule();
    private InjectionManager injector;

    @Before
    public void setUp() {
        this.injector = Injections.createInjectionManager();
        this.injector.register((Binder)new SystemConfiguration.Binder());
        this.injector.register((Binder)new HibernateServiceRegistryFactory.Binder());
        this.injector.register((Binder)new HibernateSessionFactoryFactory.Binder());
        this.injector.register((Binder)new HibernateSessionFactory.Binder());
        this.injector.completeRegistration();
    }

    @After
    public void tearDown() {
        this.injector.shutdown();
        this.injector = null;
    }

    @Test
    public void testProvideDispose() {
        SessionFactory sessionFactory = (SessionFactory)this.injector.getInstance(SessionFactory.class);
        HibernateSessionFactory factory = new HibernateSessionFactory(sessionFactory);
        Session session = factory.get();
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((boolean)session.isOpen());
        factory.dispose(session);
        Assert.assertFalse((boolean)session.isOpen());
        factory.dispose(session);
        Assert.assertFalse((boolean)session.isOpen());
        factory.dispose(null);
    }
}

