/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.id;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.math.BigInteger;
import net.krotscheck.kangaroo.common.hibernate.entity.TestChildEntity;
import net.krotscheck.kangaroo.common.hibernate.entity.TestPrivateEntity;
import net.krotscheck.kangaroo.common.hibernate.id.AbstractEntityReferenceDeserializer;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public final class AbstractEntityReferenceDeserializerTest {
    @Test
    public void testAbstractConstructor() throws Exception {
        BigInteger intId = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)intId));
        TestDeserializer deserializer = new TestDeserializer();
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        TestChildEntity e = (TestChildEntity)((Object)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class)));
        Assert.assertEquals((Object)intId, (Object)e.getId());
    }

    @Test
    public void testDeserializeSimple() throws Exception {
        BigInteger intId = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)intId));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        TestDeserializer deserializer = new TestDeserializer();
        TestChildEntity e = (TestChildEntity)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)intId, (Object)e.getId());
    }

    @Test(expected=JsonMappingException.class)
    public void testSerializePrivate() throws Exception {
        BigInteger intId = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)intId));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        TestPrivateDeserializer deserializer = new TestPrivateDeserializer();
        DeserializationContext context = (DeserializationContext)Mockito.mock(DeserializationContext.class);
        ((DeserializationContext)Mockito.doCallRealMethod().when((Object)context)).mappingException(Matchers.anyString());
        deserializer.deserialize(preloadedParser, context);
    }

    @Test(expected=JsonMappingException.class)
    public void testSerializeNoValue() throws Exception {
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser("\"\"");
        preloadedParser.nextToken();
        TestPrivateDeserializer deserializer = new TestPrivateDeserializer();
        DeserializationContext context = (DeserializationContext)Mockito.mock(DeserializationContext.class);
        ((DeserializationContext)Mockito.doCallRealMethod().when((Object)context)).mappingException(Matchers.anyString());
        deserializer.deserialize(preloadedParser, context);
    }

    @Test(expected=JsonMappingException.class)
    public void testSerializeNullValue() throws Exception {
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser("\"null\"");
        preloadedParser.nextToken();
        TestPrivateDeserializer deserializer = new TestPrivateDeserializer();
        DeserializationContext context = (DeserializationContext)Mockito.mock(DeserializationContext.class);
        ((DeserializationContext)Mockito.doCallRealMethod().when((Object)context)).mappingException(Matchers.anyString());
        deserializer.deserialize(preloadedParser, context);
    }

    public static class TestPrivateDeserializer
    extends AbstractEntityReferenceDeserializer<TestPrivateEntity> {
        TestPrivateDeserializer() {
            super(TestPrivateEntity.class);
        }
    }

    public static class TestDeserializer
    extends AbstractEntityReferenceDeserializer<TestChildEntity> {
        TestDeserializer() {
            super(TestChildEntity.class);
        }
    }
}

