/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.id;

import java.lang.annotation.Annotation;
import java.math.BigInteger;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ext.ParamConverter;
import net.krotscheck.kangaroo.common.hibernate.id.Base16BigIntegerConverterProvider;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.id.MalformedIdException;
import org.junit.Assert;
import org.junit.Test;

public final class Base16BigIntegerConverterProviderTest {
    private Base16BigIntegerConverterProvider converterProvider = new Base16BigIntegerConverterProvider();
    private Annotation pathAnnotation = new PathParam(){

        public Class<? extends Annotation> annotationType() {
            return PathParam.class;
        }

        public String value() {
            return null;
        }
    };
    private Annotation formAnnotation = new FormParam(){

        public Class<? extends Annotation> annotationType() {
            return FormParam.class;
        }

        public String value() {
            return null;
        }
    };
    private Annotation queryAnnotation = new QueryParam(){

        public Class<? extends Annotation> annotationType() {
            return QueryParam.class;
        }

        public String value() {
            return null;
        }
    };
    private Annotation otherAnnotation = new DefaultValue(){

        public Class<? extends Annotation> annotationType() {
            return DefaultValue.class;
        }

        public String value() {
            return null;
        }
    };

    @Test
    public void testBigIntegerOnly() {
        Annotation[] annotations = new Annotation[]{this.pathAnnotation, this.queryAnnotation};
        Assert.assertNotNull((Object)this.converterProvider.getConverter(BigInteger.class, null, annotations));
        Assert.assertNull((Object)this.converterProvider.getConverter(Integer.class, null, annotations));
        Assert.assertNull((Object)this.converterProvider.getConverter(String.class, null, annotations));
        Assert.assertNull((Object)this.converterProvider.getConverter(Byte.class, null, annotations));
        Assert.assertNull((Object)this.converterProvider.getConverter(Double.class, null, annotations));
        Assert.assertNull((Object)this.converterProvider.getConverter(Number.class, null, annotations));
    }

    @Test
    public void testNoAnnotation() {
        Annotation[] annotations = new Annotation[]{};
        Assert.assertNull((Object)this.converterProvider.getConverter(BigInteger.class, null, annotations));
    }

    @Test
    public void testOnlyQueryParam() {
        Annotation[] annotations = new Annotation[]{this.queryAnnotation};
        Assert.assertNotNull((Object)this.converterProvider.getConverter(BigInteger.class, null, annotations));
    }

    @Test
    public void testOnlyFormParam() {
        Annotation[] annotations = new Annotation[]{this.formAnnotation};
        Assert.assertNotNull((Object)this.converterProvider.getConverter(BigInteger.class, null, annotations));
    }

    @Test
    public void testOnlyPathParam() {
        Annotation[] annotations = new Annotation[]{this.pathAnnotation};
        Assert.assertNotNull((Object)this.converterProvider.getConverter(BigInteger.class, null, annotations));
    }

    @Test
    public void testNonSupportedAnnotation() {
        Annotation[] annotations = new Annotation[]{this.otherAnnotation};
        Assert.assertNull((Object)this.converterProvider.getConverter(BigInteger.class, null, annotations));
    }

    @Test
    public void testConvertBigInteger() {
        Annotation[] annotations = new Annotation[]{this.pathAnnotation};
        ParamConverter converter = this.converterProvider.getConverter(BigInteger.class, null, annotations);
        BigInteger id = IdUtil.next();
        String idString = converter.toString((Object)id);
        Assert.assertEquals((Object)idString, (Object)IdUtil.toString((BigInteger)id));
    }

    @Test(expected=NotFoundException.class)
    public void testFailConvertPath() {
        Annotation[] annotations = new Annotation[]{this.pathAnnotation};
        ParamConverter converter = this.converterProvider.getConverter(BigInteger.class, null, annotations);
        converter.fromString("not_a_valid_string");
    }

    @Test(expected=MalformedIdException.class)
    public void testFailConvertForm() {
        Annotation[] annotations = new Annotation[]{this.formAnnotation};
        ParamConverter converter = this.converterProvider.getConverter(BigInteger.class, null, annotations);
        converter.fromString("not_a_valid_string");
    }

    @Test(expected=MalformedIdException.class)
    public void testFailConvertQuery() {
        Annotation[] annotations = new Annotation[]{this.queryAnnotation};
        ParamConverter converter = this.converterProvider.getConverter(BigInteger.class, null, annotations);
        converter.fromString("not_a_valid_string");
    }

    @Test
    public void testValidConversion() {
        Annotation[] annotations = new Annotation[]{this.pathAnnotation};
        ParamConverter converter = this.converterProvider.getConverter(BigInteger.class, null, annotations);
        BigInteger id = IdUtil.next();
        BigInteger converted = (BigInteger)converter.fromString(IdUtil.toString((BigInteger)id));
        Assert.assertEquals((Object)id, (Object)converted);
    }
}

