/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.id;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.junit.Assert;
import org.junit.Test;

public final class IdUtilTest {
    @Test
    public void testPrivateConstructor() throws Exception {
        Constructor c = IdUtil.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(c.getModifiers()));
        c.setAccessible(true);
        c.newInstance(new Object[0]);
    }

    @Test
    public void testIdStringConvert() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            BigInteger id = IdUtil.next();
            String idString = IdUtil.toString((BigInteger)id);
            Assert.assertEquals((Object)id, (Object)IdUtil.fromString((String)idString));
            Assert.assertEquals((String)String.valueOf(i), (long)32L, (long)idString.length());
        }
    }

    @Test
    public void testNullSafeStringConvert() {
        Assert.assertNull((Object)IdUtil.toString(null));
        Assert.assertNull((Object)IdUtil.fromString(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMalformedIdFromString() {
        IdUtil.fromString((String)"notBase16String");
    }
}

