/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.id;

import java.math.BigInteger;
import net.krotscheck.kangaroo.common.hibernate.entity.TestEntity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.id.SecureRandomIdGenerator;
import net.krotscheck.kangaroo.test.TestConfig;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import org.hibernate.Session;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerationException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;

public final class SecureRandomIdGeneratorTest
extends DatabaseTest {
    @Test
    public void assertAnnotationPersistence() {
        TestEntity e = new TestEntity();
        e.setName("foo");
        Session s = this.getSession();
        s.beginTransaction();
        s.save((Object)e);
        s.getTransaction().commit();
        Assert.assertNotNull((Object)((Object)e));
        Assert.assertNotNull((Object)e.getId());
    }

    @Test
    public void assertGenerateSimple() throws Exception {
    }

    @Test
    public void assertGenerateSimpleNoConflict() throws Exception {
        SecureRandomIdGenerator generator = (SecureRandomIdGenerator)Mockito.spy((Object)new SecureRandomIdGenerator());
        ((SecureRandomIdGenerator)Mockito.doReturn((Object)true, (Object[])new Object[]{true, false}).when((Object)generator)).hasDuplicate((SharedSessionContractImplementor)ArgumentMatchers.any(), (BigInteger)ArgumentMatchers.any());
        BigInteger id = (BigInteger)generator.generate((SharedSessionContractImplementor)this.getSession(), null);
        Assert.assertNotNull((Object)id);
        ((SecureRandomIdGenerator)Mockito.verify((Object)generator, (VerificationMode)VerificationModeFactory.times((int)3))).hasDuplicate((SharedSessionContractImplementor)ArgumentMatchers.any(), (BigInteger)ArgumentMatchers.any());
    }

    @Test
    public void assertDuplicateFalseOnNoMatch() throws Exception {
        SecureRandomIdGenerator generator = new SecureRandomIdGenerator();
        generator.setSql("select count(id) from test where id=?");
        Boolean result = generator.hasDuplicate((SharedSessionContractImplementor)this.getSession(), IdUtil.next());
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void assertDuplicateTrueMatch() throws Exception {
        TestEntity e = new TestEntity();
        e.setName("foo");
        Session s = this.getSession();
        s.beginTransaction();
        s.save((Object)e);
        s.getTransaction().commit();
        SecureRandomIdGenerator generator = new SecureRandomIdGenerator();
        generator.setSql("select count(id) from test where id=?");
        Boolean result = generator.hasDuplicate((SharedSessionContractImplementor)this.getSession(), e.getId());
        Assert.assertTrue((boolean)result);
    }

    @Test(expected=IdentifierGenerationException.class)
    public void assertIdentifierExceptionOnMismatch() throws Exception {
        SecureRandomIdGenerator generator = new SecureRandomIdGenerator();
        String sql = "signal set message_text='an error occurred';";
        if (TestConfig.getDbDialect().equals(H2Dialect.class.getName())) {
            sql = "select id from test where 1=0";
        }
        generator.setSql(sql);
        generator.hasDuplicate((SharedSessionContractImplementor)this.getSession(), null);
    }

    @Test
    public void assertFalseOnNoResults() throws Exception {
        SecureRandomIdGenerator generator = new SecureRandomIdGenerator();
        generator.setSql("select * from test where 1=?");
        Boolean result = generator.hasDuplicate((SharedSessionContractImplementor)this.getSession(), null);
        Assert.assertFalse((boolean)result);
    }
}

