/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.listener;

import java.io.Serializable;
import java.util.Calendar;
import net.krotscheck.kangaroo.common.hibernate.entity.TestEntity;
import net.krotscheck.kangaroo.common.hibernate.listener.CreatedUpdatedListener;
import net.krotscheck.kangaroo.test.jersey.BinderAssertion;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.event.service.spi.EventListenerRegistrationException;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class CreatedUpdatedListenerTest
extends DatabaseTest {
    @Before
    public void setUp() {
        SessionFactory factory = this.getSessionFactory();
        ServiceRegistryImplementor registry = ((SessionFactoryImpl)factory).getServiceRegistry();
        EventListenerRegistry eventRegistry = (EventListenerRegistry)registry.getService(EventListenerRegistry.class);
        try {
            eventRegistry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{new CreatedUpdatedListener()});
            eventRegistry.appendListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{new CreatedUpdatedListener()});
        }
        catch (EventListenerRegistrationException eventListenerRegistrationException) {
            // empty catch block
        }
    }

    @Test
    public void testOnPreInsert() {
        TestEntity a = new TestEntity();
        a.setName("foo");
        Assert.assertNull((Object)a.getCreatedDate());
        Assert.assertNull((Object)a.getModifiedDate());
        Session s = this.getSession();
        s.getTransaction().begin();
        s.saveOrUpdate((Object)a);
        s.getTransaction().commit();
        Assert.assertNotNull((Object)a.getCreatedDate());
        Assert.assertNotNull((Object)a.getModifiedDate());
        s.evict((Object)a);
        TestEntity testEntity = (TestEntity)((Object)s.get(TestEntity.class, (Serializable)a.getId()));
        Assert.assertNotNull((Object)testEntity.getCreatedDate());
        Assert.assertNotNull((Object)testEntity.getModifiedDate());
    }

    @Test
    public synchronized void testOnPreUpdate() throws InterruptedException {
        TestEntity a = new TestEntity();
        a.setName("foo");
        Session s = this.getSession();
        s.getTransaction().begin();
        s.saveOrUpdate((Object)a);
        s.getTransaction().commit();
        s.evict((Object)a);
        s.getTransaction().begin();
        a = (TestEntity)((Object)s.get(TestEntity.class, (Serializable)a.getId()));
        s.getTransaction().commit();
        Calendar created = a.getCreatedDate();
        Calendar modified = a.getModifiedDate();
        this.wait(1000L);
        a.setName("bar");
        s.getTransaction().begin();
        s.saveOrUpdate((Object)a);
        s.getTransaction().commit();
        Assert.assertEquals((Object)created, (Object)a.getCreatedDate());
        Assert.assertNotEquals((Object)modified, (Object)a.getModifiedDate());
        Calendar newModifiedDate = a.getModifiedDate();
        s.evict((Object)a);
        TestEntity testEntity = (TestEntity)((Object)s.get(TestEntity.class, (Serializable)a.getId()));
        Assert.assertEquals((Object)created, (Object)testEntity.getCreatedDate());
        Assert.assertEquals((Object)newModifiedDate, (Object)testEntity.getModifiedDate());
        Assert.assertNotEquals((Object)modified, (Object)testEntity.getModifiedDate());
    }

    @Test
    public void testNotAbstractEntity() {
        CreatedUpdatedListener listener = new CreatedUpdatedListener();
        PreUpdateEvent updateEvent = (PreUpdateEvent)Mockito.mock(PreUpdateEvent.class);
        PreInsertEvent insertEvent = (PreInsertEvent)Mockito.mock(PreInsertEvent.class);
        Object entity = Mockito.spy(Object.class);
        Mockito.when((Object)updateEvent.getEntity()).thenReturn(entity);
        Mockito.when((Object)insertEvent.getEntity()).thenReturn(entity);
        listener.onPreInsert(insertEvent);
        Mockito.verifyZeroInteractions((Object[])new Object[]{entity});
        listener.onPreUpdate(updateEvent);
        Mockito.verifyZeroInteractions((Object[])new Object[]{entity});
    }

    @Test
    public void testBinder() {
        BinderAssertion.assertBinderContains((AbstractBinder)new CreatedUpdatedListener.Binder(), PreInsertEventListener.class, PreUpdateEventListener.class);
    }
}

