/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.mapper;

import java.util.HashSet;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.mapper.ConstraintViolationExceptionMapper;
import net.krotscheck.kangaroo.test.jersey.BinderAssertion;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class ConstraintViolationExceptionMapperTest {
    @Test
    public void testToResponse() {
        HashSet<ConstraintViolation> violations = new HashSet<ConstraintViolation>();
        ConstraintViolation m = (ConstraintViolation)Mockito.mock(ConstraintViolation.class);
        Mockito.when((Object)m.getMessage()).thenReturn((Object)"test 1");
        violations.add(m);
        ConstraintViolationExceptionMapper mapper = new ConstraintViolationExceptionMapper();
        ConstraintViolationException e = new ConstraintViolationException("message", violations);
        Response r = mapper.toResponse(e);
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"test 1", (Object)er.getErrorDescription());
    }

    @Test
    public void testBinder() {
        BinderAssertion.assertBinderContains((AbstractBinder)new ConstraintViolationExceptionMapper.Binder(), ExceptionMapper.class);
    }
}

