/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.mapper;

import java.sql.SQLException;
import javax.persistence.PersistenceException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.mapper.PersistenceExceptionMapper;
import net.krotscheck.kangaroo.test.jersey.BinderAssertion;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.hibernate.exception.ConstraintViolationException;
import org.junit.Assert;
import org.junit.Test;

public final class PersistenceExceptionMapperTest {
    @Test
    public void testToResponse() {
        ConstraintViolationException cause = new ConstraintViolationException("Test Exception", new SQLException(), "constraintName");
        PersistenceException e = new PersistenceException("Test", (Throwable)cause);
        PersistenceExceptionMapper mapper = new PersistenceExceptionMapper();
        Response r = mapper.toResponse(e);
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.CONFLICT.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.CONFLICT, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"Conflict", (Object)er.getErrorDescription());
    }

    @Test
    public void testToResponseNoCause() {
        PersistenceExceptionMapper mapper = new PersistenceExceptionMapper();
        PersistenceException e = new PersistenceException("test");
        Response r = mapper.toResponse(e);
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.INTERNAL_SERVER_ERROR, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"Internal Server Error", (Object)er.getErrorDescription());
    }

    @Test
    public void testBinder() {
        BinderAssertion.assertBinderContains((AbstractBinder)new PersistenceExceptionMapper.Binder(), ExceptionMapper.class);
    }
}

