/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.mapper.SearchExceptionMapper;
import net.krotscheck.kangaroo.test.jersey.BinderAssertion;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.hibernate.search.exception.EmptyQueryException;
import org.hibernate.search.exception.SearchException;
import org.junit.Assert;
import org.junit.Test;

public final class SearchExceptionMapperTest {
    @Test
    public void testToResponse() {
        SearchExceptionMapper mapper = new SearchExceptionMapper();
        SearchException e = new SearchException("test");
        Response r = mapper.toResponse(e);
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.INTERNAL_SERVER_ERROR, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"Internal Server Error", (Object)er.getErrorDescription());
    }

    @Test
    public void testEmptyQueryResponse() {
        SearchExceptionMapper mapper = new SearchExceptionMapper();
        EmptyQueryException e = new EmptyQueryException();
        Response r = mapper.toResponse((SearchException)e);
        ErrorResponseBuilder.ErrorResponse er = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)er.getHttpStatus());
        Assert.assertEquals((Object)"HTTP 400 Bad Request", (Object)er.getErrorDescription());
    }

    @Test
    public void testBinder() {
        BinderAssertion.assertBinderContains((AbstractBinder)new SearchExceptionMapper.Binder(), ExceptionMapper.class);
    }
}

