/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.migration;

import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.exception.LiquibaseException;
import net.krotscheck.kangaroo.common.hibernate.migration.DatabaseMigrationState;
import net.krotscheck.kangaroo.common.hibernate.migration.LiquibaseMigration;
import net.krotscheck.kangaroo.test.jersey.BinderAssertion;
import net.krotscheck.kangaroo.test.rule.DatabaseResource;
import net.krotscheck.kangaroo.test.rule.WorkingDirectoryRule;
import net.krotscheck.kangaroo.test.rule.database.ITestDatabase;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class LiquibaseMigrationTest {
    @Rule
    public final WorkingDirectoryRule workingDir = new WorkingDirectoryRule();
    private String testingMigration = "liquibase/db.changelog-commons-master.yaml";

    @After
    public void reset() {
        DatabaseFactory.reset();
    }

    private boolean hasTestTable(Connection c) throws Exception {
        DatabaseMetaData m = c.getMetaData();
        ResultSet rs = m.getTables(c.getCatalog(), null, "%", null);
        List<Object> tables = new ArrayList<String>();
        while (rs.next()) {
            tables.add(rs.getString("TABLE_NAME"));
        }
        rs.close();
        tables = tables.stream().map(String::toLowerCase).filter("test"::equals).collect(Collectors.toList());
        return tables.size() > 0;
    }

    @Test
    public void testMigrateOnStartup() throws Exception {
        DatabaseResource resource = new DatabaseResource();
        try (ITestDatabase db = resource.createDatabase();
             Connection c = db.getConnection();){
            Assert.assertFalse((boolean)this.hasTestTable(c));
            PooledDataSource ps = (PooledDataSource)Mockito.mock(PooledDataSource.class);
            Connection testConnection = db.getConnection();
            ((PooledDataSource)Mockito.doReturn((Object)testConnection).when((Object)ps)).getConnection();
            LiquibaseMigration listener = new LiquibaseMigration(ps);
            listener.setMigrationPath(this.testingMigration);
            listener.get();
            Assert.assertTrue((boolean)testConnection.isClosed());
            Assert.assertTrue((boolean)this.hasTestTable(c));
        }
    }

    @Test
    public void testExitOnMigrationFailureLiquibaseException() throws Exception {
        PooledDataSource ps = (PooledDataSource)Mockito.mock(PooledDataSource.class);
        ((PooledDataSource)Mockito.doThrow(LiquibaseException.class).when((Object)ps)).getConnection();
        LiquibaseMigration listener = new LiquibaseMigration(ps);
        listener.setMigrationPath(this.testingMigration);
        try {
            listener.get();
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testExitOnMigrationFailureSQLException() throws Exception {
        PooledDataSource ps = (PooledDataSource)Mockito.mock(PooledDataSource.class);
        ((PooledDataSource)Mockito.doThrow(SQLException.class).when((Object)ps)).getConnection();
        LiquibaseMigration listener = new LiquibaseMigration(ps);
        listener.setMigrationPath(this.testingMigration);
        try {
            listener.get();
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testExitOnMigrationFailureNullConnection() throws Exception {
        PooledDataSource ps = (PooledDataSource)Mockito.mock(PooledDataSource.class);
        ((PooledDataSource)Mockito.doReturn(null).when((Object)ps)).getConnection();
        LiquibaseMigration listener = new LiquibaseMigration(ps);
        listener.setMigrationPath(this.testingMigration);
        try {
            listener.get();
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testExitAndCloseOnInternalException() throws Exception {
        DatabaseResource resource = new DatabaseResource();
        try (ITestDatabase db = resource.createDatabase();
             Connection c = db.getConnection();){
            Assert.assertFalse((boolean)this.hasTestTable(c));
            PooledDataSource ps = (PooledDataSource)Mockito.mock(PooledDataSource.class);
            Connection testConnection = db.getConnection();
            ((PooledDataSource)Mockito.doReturn((Object)testConnection).when((Object)ps)).getConnection();
            DatabaseFactory mockFactory = (DatabaseFactory)Mockito.mock(DatabaseFactory.class);
            ((DatabaseFactory)Mockito.doThrow(SQLException.class).when((Object)mockFactory)).findCorrectDatabaseImplementation((DatabaseConnection)ArgumentMatchers.any());
            DatabaseFactory.setInstance((DatabaseFactory)mockFactory);
            try {
                LiquibaseMigration listener = new LiquibaseMigration(ps);
                listener.setMigrationPath(this.testingMigration);
                listener.get();
                Assert.fail();
            }
            catch (RuntimeException e) {
                Assert.assertNotNull((Object)e);
            }
            Assert.assertTrue((boolean)testConnection.isClosed());
            Assert.assertFalse((boolean)this.hasTestTable(c));
        }
    }

    @Test
    public void testExitAndCloseOnUnexpectedException() throws Exception {
        DatabaseResource resource = new DatabaseResource();
        try (ITestDatabase db = resource.createDatabase();
             Connection c = db.getConnection();){
            Assert.assertFalse((boolean)this.hasTestTable(c));
            PooledDataSource ps = (PooledDataSource)Mockito.mock(PooledDataSource.class);
            Connection testConnection = db.getConnection();
            ((PooledDataSource)Mockito.doReturn((Object)testConnection).when((Object)ps)).getConnection();
            DatabaseFactory mockFactory = (DatabaseFactory)Mockito.mock(DatabaseFactory.class);
            ((DatabaseFactory)Mockito.doThrow(BadRequestException.class).when((Object)mockFactory)).findCorrectDatabaseImplementation((DatabaseConnection)ArgumentMatchers.any());
            DatabaseFactory.setInstance((DatabaseFactory)mockFactory);
            try {
                LiquibaseMigration listener = new LiquibaseMigration(ps);
                listener.get();
                Assert.fail();
            }
            catch (BadRequestException e) {
                Assert.assertNotNull((Object)((Object)e));
            }
            Assert.assertTrue((boolean)testConnection.isClosed());
            Assert.assertFalse((boolean)this.hasTestTable(c));
        }
    }

    @Test
    public void testBinder() {
        BinderAssertion.assertBinderContains((AbstractBinder)new LiquibaseMigration.Binder(), DatabaseMigrationState.class);
    }
}

