/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.migration;

import java.util.ArrayList;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.precondition.core.PreconditionContainer;
import net.krotscheck.kangaroo.common.hibernate.migration.LiquibaseMigrationWatcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class LiquibaseMigrationWatcherTest {
    @Test
    public void testConstructorWithNoChangesets() {
        ArrayList changeSets = new ArrayList();
        LiquibaseMigrationWatcher w = new LiquibaseMigrationWatcher(changeSets);
        Assert.assertNull((Object)w.getCurrentVersion());
    }

    @Test
    public void testConstructorWithRunChangesets() {
        ChangeSet mockSet = (ChangeSet)Mockito.mock(ChangeSet.class);
        ChangeSetStatus mockStatus = (ChangeSetStatus)Mockito.mock(ChangeSetStatus.class);
        ((ChangeSetStatus)Mockito.doReturn((Object)true).when((Object)mockStatus)).getPreviouslyRan();
        ((ChangeSetStatus)Mockito.doReturn((Object)mockSet).when((Object)mockStatus)).getChangeSet();
        ArrayList<ChangeSetStatus> changeSets = new ArrayList<ChangeSetStatus>();
        changeSets.add(mockStatus);
        LiquibaseMigrationWatcher w = new LiquibaseMigrationWatcher(changeSets);
        Assert.assertSame((Object)mockSet, (Object)w.getCurrentVersion());
    }

    @Test
    public void testConstructorWithUnrunChangesets() {
        ChangeSet mockSet = (ChangeSet)Mockito.mock(ChangeSet.class);
        ChangeSetStatus mockStatus = (ChangeSetStatus)Mockito.mock(ChangeSetStatus.class);
        ((ChangeSetStatus)Mockito.doReturn((Object)false).when((Object)mockStatus)).getPreviouslyRan();
        ((ChangeSetStatus)Mockito.doReturn((Object)mockSet).when((Object)mockStatus)).getChangeSet();
        ArrayList<ChangeSetStatus> changeSets = new ArrayList<ChangeSetStatus>();
        changeSets.add(mockStatus);
        LiquibaseMigrationWatcher w = new LiquibaseMigrationWatcher(changeSets);
        Assert.assertNull((Object)w.getCurrentVersion());
    }

    @Test
    public void testConstructorReturnsLastRunChangSet() {
        ArrayList<ChangeSetStatus> changeSets = new ArrayList<ChangeSetStatus>();
        for (int i = 0; i < 10; ++i) {
            ChangeSet mockSet = (ChangeSet)Mockito.mock(ChangeSet.class);
            ChangeSetStatus mockStatus = (ChangeSetStatus)Mockito.mock(ChangeSetStatus.class);
            ((ChangeSetStatus)Mockito.doReturn((Object)true).when((Object)mockStatus)).getPreviouslyRan();
            ((ChangeSetStatus)Mockito.doReturn((Object)mockSet).when((Object)mockStatus)).getChangeSet();
            changeSets.add(mockStatus);
        }
        ChangeSet lastSet = ((ChangeSetStatus)changeSets.get(changeSets.size() - 1)).getChangeSet();
        for (int i = 0; i < 10; ++i) {
            ChangeSet mockSet = (ChangeSet)Mockito.mock(ChangeSet.class);
            ChangeSetStatus mockStatus = (ChangeSetStatus)Mockito.mock(ChangeSetStatus.class);
            ((ChangeSetStatus)Mockito.doReturn((Object)false).when((Object)mockStatus)).getPreviouslyRan();
            ((ChangeSetStatus)Mockito.doReturn((Object)mockSet).when((Object)mockStatus)).getChangeSet();
            changeSets.add(mockStatus);
        }
        LiquibaseMigrationWatcher w = new LiquibaseMigrationWatcher(changeSets);
        Assert.assertSame((Object)lastSet, (Object)w.getCurrentVersion());
    }

    @Test
    public void testUnimplementedMethods() {
        ArrayList changeSets = new ArrayList();
        LiquibaseMigrationWatcher w = new LiquibaseMigrationWatcher(changeSets);
        Change mockChange = (Change)Mockito.mock(Change.class);
        ChangeSet mockChangeSet = (ChangeSet)Mockito.mock(ChangeSet.class);
        DatabaseChangeLog mockDbChangeLog = (DatabaseChangeLog)Mockito.mock(DatabaseChangeLog.class);
        Database mockDatabase = (Database)Mockito.mock(Database.class);
        PreconditionFailedException mockPFE = (PreconditionFailedException)Mockito.mock(PreconditionFailedException.class);
        PreconditionErrorException mockPEE = (PreconditionErrorException)Mockito.mock(PreconditionErrorException.class);
        w.willRun(mockChangeSet, mockDbChangeLog, mockDatabase, ChangeSet.RunStatus.MARK_RAN);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockChangeSet});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDbChangeLog});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDatabase});
        w.willRun(mockChange, mockChangeSet, mockDbChangeLog, mockDatabase);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockChange});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockChangeSet});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDbChangeLog});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDatabase});
        w.ran(mockChangeSet, mockDbChangeLog, mockDatabase, ChangeSet.ExecType.EXECUTED);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockChangeSet});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDbChangeLog});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDatabase});
        w.ran(mockChange, mockChangeSet, mockDbChangeLog, mockDatabase);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockChange});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockChangeSet});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDbChangeLog});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDatabase});
        w.rolledBack(mockChangeSet, mockDbChangeLog, mockDatabase);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockChangeSet});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDbChangeLog});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDatabase});
        w.runFailed(mockChangeSet, mockDbChangeLog, mockDatabase, (Exception)mockPEE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockChangeSet});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDbChangeLog});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockDatabase});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockPEE});
        w.preconditionFailed(mockPFE, PreconditionContainer.FailOption.HALT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockPFE});
        w.preconditionErrored(mockPEE, PreconditionContainer.ErrorOption.HALT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockPEE});
    }

    @Test
    public void ran() {
        ArrayList changeSets = new ArrayList();
        ChangeSet mockChangeSet = (ChangeSet)Mockito.mock(ChangeSet.class);
        DatabaseChangeLog mockDbChangeLog = (DatabaseChangeLog)Mockito.mock(DatabaseChangeLog.class);
        Database mockDatabase = (Database)Mockito.mock(Database.class);
        LiquibaseMigrationWatcher w = new LiquibaseMigrationWatcher(changeSets);
        Assert.assertFalse((boolean)w.isMigrated());
        Assert.assertNull((Object)w.getCurrentVersion());
        w.ran(mockChangeSet, mockDbChangeLog, mockDatabase, ChangeSet.ExecType.EXECUTED);
        Assert.assertTrue((boolean)w.isMigrated());
        Assert.assertSame((Object)mockChangeSet, (Object)w.getCurrentVersion());
    }
}

