/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.transaction;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.hibernate.transaction.TransactionFilter;
import net.krotscheck.kangaroo.test.jersey.BinderAssertion;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class TransactionFilterTest {
    private Provider<Session> mockSessionProvider;
    private Session mockSession;
    private Transaction mockTransaction;
    private ContainerRequestContext requestContext;
    private ContainerResponseContext responseContext;

    @Before
    public void setUp() {
        this.mockTransaction = (Transaction)Mockito.mock(Transaction.class);
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockSessionProvider = (Provider)Mockito.mock(Provider.class);
        this.requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        this.responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        ((Provider)Mockito.doReturn((Object)this.mockSession).when(this.mockSessionProvider)).get();
        ((Session)Mockito.doReturn((Object)this.mockTransaction).when((Object)this.mockSession)).getTransaction();
        ((Session)Mockito.doReturn((Object)this.mockTransaction).when((Object)this.mockSession)).getTransaction();
        ((Transaction)Mockito.doReturn((Object)TransactionStatus.ACTIVE).when((Object)this.mockTransaction)).getStatus();
    }

    @Test
    public void testRequestFilter() throws Exception {
        TransactionFilter filter = new TransactionFilter(this.mockSessionProvider);
        filter.filter(this.requestContext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestContext});
        ((Transaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)1))).begin();
    }

    @Test
    public void testResponseFilter() throws Exception {
        TransactionFilter filter = new TransactionFilter(this.mockSessionProvider);
        filter.filter(this.requestContext, this.responseContext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestContext});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.responseContext});
        ((Transaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)1))).commit();
    }

    @Test
    public void testResponseFilterNoActiveState() throws Exception {
        List statuses = Arrays.stream(TransactionStatus.values()).filter(t -> !t.equals((Object)TransactionStatus.ACTIVE)).collect(Collectors.toList());
        for (TransactionStatus s : statuses) {
            ((Transaction)Mockito.doReturn((Object)s).when((Object)this.mockTransaction)).getStatus();
            TransactionFilter filter = new TransactionFilter(this.mockSessionProvider);
            filter.filter(this.requestContext, this.responseContext);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestContext});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.responseContext});
            ((Transaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        }
    }

    @Test
    public void testResponseFilterError() throws Exception {
        ((Transaction)Mockito.doThrow(HibernateException.class).when((Object)this.mockTransaction)).commit();
        TransactionFilter filter = new TransactionFilter(this.mockSessionProvider);
        filter.filter(this.requestContext, this.responseContext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestContext});
        ((Transaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)1))).commit();
        ((Transaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)1))).rollback();
        ((ContainerResponseContext)Mockito.verify((Object)this.responseContext, (VerificationMode)Mockito.times((int)1))).setEntity(Matchers.any());
        ((ContainerResponseContext)Mockito.verify((Object)this.responseContext, (VerificationMode)Mockito.times((int)1))).setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        ((ContainerResponseContext)Mockito.verify((Object)this.responseContext, (VerificationMode)Mockito.times((int)1))).setEntity(Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.responseContext});
    }

    @Test
    public void testBinder() {
        BinderAssertion.assertBinderContains((AbstractBinder)new TransactionFilter.Binder(), ContainerRequestFilter.class, ContainerResponseFilter.class);
    }
}

