/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.type;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.type.BigIntegerType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class BigIntegerTypeTest {
    @Test
    public void sqlTypes() {
        BigIntegerType type = new BigIntegerType();
        int[] types = type.sqlTypes();
        Assert.assertEquals((long)1L, (long)types.length);
        Assert.assertEquals((long)-2L, (long)types[0]);
    }

    @Test
    public void returnedClass() {
        BigIntegerType type = new BigIntegerType();
        Assert.assertEquals(BigInteger.class, (Object)type.returnedClass());
    }

    @Test
    public void equals() {
        BigIntegerType type = new BigIntegerType();
        BigInteger one = IdUtil.next();
        BigInteger two = new BigInteger(one.toByteArray());
        BigInteger three = IdUtil.next();
        Assert.assertTrue((boolean)type.equals((Object)one, (Object)two));
        Assert.assertFalse((boolean)type.equals((Object)three, (Object)two));
        Assert.assertFalse((boolean)type.equals((Object)two, (Object)three));
        Assert.assertTrue((boolean)type.equals(null, null));
        Assert.assertFalse((boolean)type.equals(null, (Object)two));
        Assert.assertFalse((boolean)type.equals((Object)two, null));
    }

    @Test
    public void testHashCode() {
        BigIntegerType type = new BigIntegerType();
        BigInteger one = IdUtil.next();
        Assert.assertEquals((long)one.hashCode(), (long)type.hashCode((Object)one));
    }

    @Test
    public void nullSafeGet() throws Exception {
        BigIntegerType type = new BigIntegerType();
        String[] names = new String[]{"test"};
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        BigInteger one = IdUtil.next();
        ((ResultSet)Mockito.doReturn((Object)one.toByteArray()).when((Object)rs)).getBytes(names[0]);
        BigInteger result = (BigInteger)type.nullSafeGet(rs, names, null, null);
        Assert.assertEquals((Object)one, (Object)result);
    }

    @Test
    public void nullSafeGetNull() throws Exception {
        BigIntegerType type = new BigIntegerType();
        String[] names = new String[]{"test"};
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ((ResultSet)Mockito.doReturn(null).when((Object)rs)).getString(names[0]);
        BigInteger result = (BigInteger)type.nullSafeGet(rs, names, null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void nullSafeSet() throws Exception {
        BigIntegerType type = new BigIntegerType();
        PreparedStatement st = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        BigInteger one = BigInteger.ONE;
        type.nullSafeSet(st, (Object)one, 0, null);
        byte[] zerofill = new byte[16];
        byte[] expected = one.toByteArray();
        System.arraycopy(expected, 0, zerofill, zerofill.length - expected.length, expected.length);
        expected = zerofill;
        ((PreparedStatement)Mockito.verify((Object)st, (VerificationMode)Mockito.times((int)1))).setBytes(0, expected);
    }

    @Test
    public void nullSafeShort() throws Exception {
        BigIntegerType type = new BigIntegerType();
        PreparedStatement st = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        BigInteger one = BigInteger.TEN;
        type.nullSafeSet(st, (Object)one, 0, null);
        ((PreparedStatement)Mockito.verify((Object)st, (VerificationMode)Mockito.times((int)1))).setBytes(0, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10});
    }

    @Test
    public void nullSafeSetNull() throws Exception {
        BigIntegerType type = new BigIntegerType();
        PreparedStatement st = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        type.nullSafeSet(st, null, 0, null);
        ((PreparedStatement)Mockito.verify((Object)st, (VerificationMode)Mockito.times((int)1))).setNull(0, -2);
    }

    @Test
    public void deepCopy() {
        BigIntegerType type = new BigIntegerType();
        BigInteger one = IdUtil.next();
        Assert.assertSame((Object)one, (Object)type.deepCopy((Object)one));
    }

    @Test
    public void isMutable() {
        BigIntegerType type = new BigIntegerType();
        Assert.assertFalse((boolean)type.isMutable());
    }

    @Test
    public void disassemble() {
        BigIntegerType type = new BigIntegerType();
        BigInteger one = IdUtil.next();
        byte[] result = (byte[])type.disassemble((Object)one);
        Assert.assertArrayEquals((byte[])one.toByteArray(), (byte[])result);
    }

    @Test
    public void assemble() {
        BigIntegerType type = new BigIntegerType();
        BigInteger one = IdUtil.next();
        BigInteger result = (BigInteger)type.assemble((Serializable)one.toByteArray(), null);
        Assert.assertTrue((boolean)one.equals(result));
    }

    @Test
    public void replace() {
        BigIntegerType type = new BigIntegerType();
        BigInteger one = IdUtil.next();
        BigInteger two = IdUtil.next();
        BigInteger result = (BigInteger)type.replace((Object)one, (Object)two, null);
        Assert.assertSame((Object)one, (Object)result);
    }
}

