/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import net.krotscheck.kangaroo.common.hibernate.type.CalendarTimestampType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class CalendarTimestampTypeTest {
    @Test
    public void sqlTypes() {
        CalendarTimestampType type = new CalendarTimestampType();
        int[] types = type.sqlTypes();
        Assert.assertEquals((long)1L, (long)types.length);
        Assert.assertEquals((long)-5L, (long)types[0]);
    }

    @Test
    public void returnedClass() {
        CalendarTimestampType type = new CalendarTimestampType();
        Assert.assertEquals(Calendar.class, (Object)type.returnedClass());
    }

    @Test
    public void equals() {
        CalendarTimestampType type = new CalendarTimestampType();
        Calendar one = Calendar.getInstance();
        Calendar two = (Calendar)one.clone();
        Calendar three = Calendar.getInstance();
        three.add(12, 1);
        Assert.assertTrue((boolean)type.equals((Object)one, (Object)two));
        Assert.assertFalse((boolean)type.equals((Object)three, (Object)two));
        Assert.assertFalse((boolean)type.equals((Object)two, (Object)three));
        Assert.assertTrue((boolean)type.equals(null, null));
        Assert.assertFalse((boolean)type.equals(null, (Object)two));
        Assert.assertFalse((boolean)type.equals((Object)two, null));
    }

    @Test
    public void testHashCode() {
        CalendarTimestampType type = new CalendarTimestampType();
        Calendar one = Calendar.getInstance();
        Assert.assertEquals((long)one.hashCode(), (long)type.hashCode((Object)one));
    }

    @Test
    public void nullSafeGet() throws Exception {
        CalendarTimestampType type = new CalendarTimestampType();
        String[] names = new String[]{"test"};
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Calendar one = Calendar.getInstance();
        ((ResultSet)Mockito.doReturn((Object)String.valueOf(one.getTimeInMillis())).when((Object)rs)).getString(names[0]);
        Calendar result = (Calendar)type.nullSafeGet(rs, names, null, null);
        Assert.assertEquals((Object)one, (Object)result);
    }

    @Test
    public void nullSafeGetNull() throws Exception {
        CalendarTimestampType type = new CalendarTimestampType();
        String[] names = new String[]{"test"};
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ((ResultSet)Mockito.doReturn(null).when((Object)rs)).getString(names[0]);
        Calendar result = (Calendar)type.nullSafeGet(rs, names, null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void nullSafeSet() throws Exception {
        CalendarTimestampType type = new CalendarTimestampType();
        PreparedStatement st = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Calendar one = Calendar.getInstance();
        type.nullSafeSet(st, (Object)one, 0, null);
        ((PreparedStatement)Mockito.verify((Object)st, (VerificationMode)Mockito.times((int)1))).setLong(0, one.getTimeInMillis());
    }

    @Test
    public void nullSafeSetNull() throws Exception {
        CalendarTimestampType type = new CalendarTimestampType();
        PreparedStatement st = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        type.nullSafeSet(st, null, 0, null);
        ((PreparedStatement)Mockito.verify((Object)st, (VerificationMode)Mockito.times((int)1))).setNull(0, -5);
    }

    @Test
    public void deepCopy() {
        CalendarTimestampType type = new CalendarTimestampType();
        Calendar one = Calendar.getInstance();
        Assert.assertSame((Object)one, (Object)type.deepCopy((Object)one));
    }

    @Test
    public void isMutable() {
        CalendarTimestampType type = new CalendarTimestampType();
        Assert.assertFalse((boolean)type.isMutable());
    }

    @Test
    public void disassemble() {
        CalendarTimestampType type = new CalendarTimestampType();
        Calendar one = Calendar.getInstance();
        long result = (Long)type.disassemble((Object)one);
        Assert.assertEquals((long)one.getTimeInMillis(), (long)result);
    }

    @Test
    public void assemble() {
        CalendarTimestampType type = new CalendarTimestampType();
        Calendar one = Calendar.getInstance();
        Calendar result = (Calendar)type.assemble((Serializable)Long.valueOf(one.getTimeInMillis()), null);
        Assert.assertTrue((boolean)one.equals(result));
    }

    @Test
    public void replace() {
        CalendarTimestampType type = new CalendarTimestampType();
        Calendar one = Calendar.getInstance();
        Calendar two = Calendar.getInstance();
        Calendar result = (Calendar)type.replace((Object)one, (Object)two, null);
        Assert.assertSame((Object)one, (Object)result);
    }
}

