/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.type;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.common.hibernate.type.URITypeDescriptor;
import org.hibernate.HibernateException;
import org.junit.Assert;
import org.junit.Test;

public final class URITypeDescriptorTest {
    private final URI testUri = UriBuilder.fromPath((String)"http://example.com").build(new Object[0]);

    @Test
    public void testGenericConstructor() throws Exception {
        URITypeDescriptor t = new URITypeDescriptor();
        URI result = (URI)t.wrap((Object)"http://example.com", null);
        Assert.assertEquals((Object)this.testUri, (Object)result);
    }

    @Test
    public void testToString() {
        String result = URITypeDescriptor.INSTANCE.toString(this.testUri);
        Assert.assertEquals((Object)"http://example.com", (Object)result);
    }

    @Test
    public void testFromString() {
        URI result = URITypeDescriptor.INSTANCE.fromString("http://example.com");
        Assert.assertEquals((Object)this.testUri, (Object)result);
    }

    @Test(expected=HibernateException.class)
    public void testFromStringNull() {
        URITypeDescriptor.INSTANCE.fromString(null);
    }

    @Test
    public void testUnwrapNull() {
        String result = (String)URITypeDescriptor.INSTANCE.unwrap(null, String.class, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testUnwrapString() {
        String result = (String)URITypeDescriptor.INSTANCE.unwrap(this.testUri, String.class, null);
        Assert.assertEquals((Object)"http://example.com", (Object)result);
    }

    @Test(expected=HibernateException.class)
    public void testUnwrapInvalid() {
        URITypeDescriptor.INSTANCE.unwrap(this.testUri, Integer.class, null);
    }

    @Test
    public void testWrapNull() {
        URI result = URITypeDescriptor.INSTANCE.wrap(null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testWrapString() {
        URI result = URITypeDescriptor.INSTANCE.wrap((Object)"http://example.com", null);
        Assert.assertEquals((Object)this.testUri, (Object)result);
    }

    @Test(expected=HibernateException.class)
    public void testWrapUnknown() {
        URITypeDescriptor.INSTANCE.wrap((Object)1000, null);
    }
}

