/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.type;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.common.hibernate.type.URIType;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MariaDBDialect;
import org.junit.Assert;
import org.junit.Test;

public final class URITypeTest {
    private final URI testUri = UriBuilder.fromPath((String)"http://example.com").build(new Object[0]);

    @Test
    public void testGenericConstructor() throws Exception {
        URIType t = new URIType();
        URI uri = (URI)t.stringToObject("http://example.com");
        Assert.assertEquals((Object)this.testUri, (Object)uri);
    }

    @Test
    public void testRegisterUnderJavaType() {
        URIType t = new URIType();
        Assert.assertTrue((boolean)t.registerUnderJavaType());
    }

    @Test
    public void testToString() {
        URIType t = new URIType();
        String uriString = t.toString(this.testUri);
        Assert.assertEquals((Object)"http://example.com", (Object)uriString);
    }

    @Test
    public void testStringToObject() throws Exception {
        URIType t = new URIType();
        URI uri = t.stringToObject("http://example.com");
        Assert.assertEquals((Object)this.testUri, (Object)uri);
    }

    @Test
    public void testObjectToSQLString() throws Exception {
        URIType t = new URIType();
        String sql = t.objectToSQLString(this.testUri, (Dialect)new MariaDBDialect());
        Assert.assertEquals((Object)"'http://example.com'", (Object)sql);
    }

    @Test
    public void testGetName() {
        URIType t = new URIType();
        Assert.assertEquals((Object)"uri", (Object)t.getName());
    }
}

