/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.httpClient;

import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import junit.framework.TestCase;
import net.krotscheck.kangaroo.common.httpClient.HttpClientFactory;
import net.krotscheck.kangaroo.common.httpClient.JerseyClientBuilderFactory;
import net.krotscheck.kangaroo.common.status.StatusFeature;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class HttpClientFactoryTest
extends ContainerTest {
    @Override
    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register(StatusFeature.class);
        return a;
    }

    @Test
    public void assertCanCreateClient() {
        JerseyClientBuilderFactory builder = new JerseyClientBuilderFactory();
        HttpClientFactory factory = new HttpClientFactory(builder.get());
        TestCase.assertNotNull((Object)factory.get());
    }

    @Test
    public void assertCanDisposeClient() {
        Client testClient = (Client)Mockito.mock(Client.class);
        JerseyClientBuilderFactory builder = new JerseyClientBuilderFactory();
        HttpClientFactory factory = new HttpClientFactory(builder.get());
        factory.dispose(testClient);
        ((Client)Mockito.verify((Object)testClient, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void assertCanUseClient() {
        URI uri = this.target("/status").getUri();
        JerseyClientBuilderFactory builder = new JerseyClientBuilderFactory();
        HttpClientFactory factory = new HttpClientFactory(builder.get());
        Client client = factory.get();
        Response r = client.target(uri.toString()).request().get();
        TestCase.assertEquals((int)200, (int)r.getStatus());
        factory.dispose(client);
    }
}

