/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.jackson;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;

public final class ObjectMapperFactoryTest {
    private static final ObjectMapperFactory FACTORY = new ObjectMapperFactory();

    @Test
    public void testConfigurationSettings() {
        ObjectMapper mapper = FACTORY.get();
        SerializationConfig serializationConfig = mapper.getSerializationConfig();
        DeserializationConfig deserializationConfig = mapper.getDeserializationConfig();
        Assert.assertTrue((boolean)deserializationConfig.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING));
        Assert.assertTrue((boolean)deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES));
        Assert.assertTrue((boolean)deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS));
        Assert.assertFalse((boolean)deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES));
        Assert.assertTrue((boolean)serializationConfig.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING));
        Assert.assertFalse((boolean)serializationConfig.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES));
    }

    @Test
    public void testDateFormat() {
        ObjectMapper mapper = FACTORY.get();
        Assert.assertTrue((boolean)(mapper.getDateFormat() instanceof ISO8601DateFormat));
    }

    @Test
    public void testSingleton() {
        Assert.assertSame((Object)FACTORY.get(), (Object)FACTORY.get());
    }
}

