/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.jackson.types;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.math.BigInteger;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.types.Base16BigIntegerDeserializer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class Base16BigIntegerDeserializerTest {
    @Test
    public void testGenericConstructor() throws Exception {
        BigInteger id = IdUtil.next();
        String idBody = String.format("\"%s\"", IdUtil.toString((BigInteger)id));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(idBody);
        preloadedParser.nextToken();
        Base16BigIntegerDeserializer deserializer = new Base16BigIntegerDeserializer();
        BigInteger deserializedId = (BigInteger)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)id, (Object)deserializedId);
    }

    @Test
    public void deserialize() throws Exception {
        BigInteger id = IdUtil.next();
        String idBody = String.format("\"%s\"", IdUtil.toString((BigInteger)id));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(idBody);
        preloadedParser.nextToken();
        Base16BigIntegerDeserializer deserializer = new Base16BigIntegerDeserializer();
        BigInteger deserializedId = deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)id, (Object)deserializedId);
    }
}

