/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.jackson.types;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.math.BigInteger;
import java.util.Calendar;
import net.krotscheck.kangaroo.common.jackson.types.Base16BigIntegerDeserializer;
import net.krotscheck.kangaroo.common.jackson.types.Base16BigIntegerSerializer;
import net.krotscheck.kangaroo.common.jackson.types.KangarooCustomTypesModule;
import net.krotscheck.kangaroo.common.jackson.types.UnixTimestampDeserializer;
import net.krotscheck.kangaroo.common.jackson.types.UnixTimestampSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public final class KangarooCustomTypesModuleTest {
    @Test
    public void getModuleName() {
        KangarooCustomTypesModule module = new KangarooCustomTypesModule();
        Assert.assertEquals((Object)"KangarooCustomTypesModule", (Object)module.getModuleName());
    }

    @Test
    public void version() {
        KangarooCustomTypesModule module = new KangarooCustomTypesModule();
        Assert.assertEquals((Object)Version.unknownVersion(), (Object)module.version());
    }

    @Test
    public void setupModule() throws Exception {
        KangarooCustomTypesModule module = new KangarooCustomTypesModule();
        Module.SetupContext c = (Module.SetupContext)Mockito.mock(Module.SetupContext.class);
        ArgumentCaptor serializers = ArgumentCaptor.forClass(Serializers.class);
        ArgumentCaptor deserializers = ArgumentCaptor.forClass(Deserializers.class);
        module.setupModule(c);
        ((Module.SetupContext)Mockito.verify((Object)c)).addSerializers((Serializers)serializers.capture());
        ((Module.SetupContext)Mockito.verify((Object)c)).addDeserializers((Deserializers)deserializers.capture());
        TypeFactory t = TypeFactory.defaultInstance();
        JavaType bigIntegerType = t.constructType(BigInteger.class);
        JavaType calendarType = t.constructType(Calendar.class);
        SimpleSerializers s = (SimpleSerializers)serializers.getValue();
        JsonSerializer byteSerializer = s.findSerializer(null, bigIntegerType, null);
        Assert.assertTrue((boolean)(byteSerializer instanceof Base16BigIntegerSerializer));
        JsonSerializer calSerializer = s.findSerializer(null, calendarType, null);
        Assert.assertTrue((boolean)(calSerializer instanceof UnixTimestampSerializer));
        SimpleDeserializers d = (SimpleDeserializers)deserializers.getValue();
        JsonDeserializer byteDeserializer = d.findBeanDeserializer(bigIntegerType, null, null);
        Assert.assertTrue((boolean)(byteDeserializer instanceof Base16BigIntegerDeserializer));
        JsonDeserializer calDeserializer = d.findBeanDeserializer(calendarType, null, null);
        Assert.assertTrue((boolean)(calDeserializer instanceof UnixTimestampDeserializer));
    }
}

