/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.jackson.types;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.util.Calendar;
import net.krotscheck.kangaroo.common.jackson.types.UnixTimestampDeserializer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class UnixTimestampDeserializerTest {
    @Test
    public void testGenericConstructor() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(14, 0);
        long unixTimestamp = c.getTimeInMillis() / 1000L;
        String idBody = String.format("%s", unixTimestamp);
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(idBody);
        preloadedParser.nextToken();
        UnixTimestampDeserializer deserializer = new UnixTimestampDeserializer();
        Calendar deserialized = (Calendar)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)c, (Object)deserialized);
    }

    @Test
    public void deserialize() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(14, 0);
        long unixTimestamp = c.getTimeInMillis() / 1000L;
        String idBody = String.format("%s", unixTimestamp);
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(idBody);
        preloadedParser.nextToken();
        UnixTimestampDeserializer deserializer = new UnixTimestampDeserializer();
        Calendar deserialized = deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)c, (Object)deserialized);
    }
}

