/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.logging;

import ch.qos.logback.classic.Level;
import java.net.URI;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.jackson.JacksonFeature;
import net.krotscheck.kangaroo.common.logging.HttpResponseLoggingFilter;
import net.krotscheck.kangaroo.test.LoggingRule;
import net.krotscheck.kangaroo.test.jersey.KangarooJerseyTest;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class HttpResponseLoggingFilterTest
extends KangarooJerseyTest {
    @Rule
    public final LoggingRule logs = new LoggingRule(HttpResponseLoggingFilter.class, Level.ALL);

    @Before
    public void clearLogs() {
        this.logs.clear();
    }

    @Override
    protected ResourceConfig createApplication() {
        ResourceConfig config = new ResourceConfig();
        config.register(JacksonFeature.class);
        config.register(HttpResponseLoggingFilter.class);
        config.register(MockService.class);
        return config;
    }

    @Test
    public void test200ErrorCodes() {
        this.target("/error/200").request().get();
        List<String> messages = this.logs.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)"200 HTTP GET error/200", (Object)messages.get(0));
    }

    @Test
    public void test300RedirectionErrorCodes() {
        this.target("/error/300").request().get();
        List<String> messages = this.logs.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)"303 HTTP GET error/300 -> https://example.com/", (Object)messages.get(0));
    }

    @Test
    public void test300ErrorCodeWithNoLocation() {
        this.target("/error/300-no-location").request().get();
        List<String> messages = this.logs.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)"300 HTTP GET error/300-no-location -> No location header provided", (Object)messages.get(0));
    }

    @Test
    public void test400ErrorCodesWithBody() {
        this.target("/error/400").request().get();
        List<String> messages = this.logs.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)"400 HTTP GET error/400: Bad Request", (Object)messages.get(0));
    }

    @Test
    public void test400ErrorCodesNoBody() {
        this.target("/error/400-no-body").request().get();
        List<String> messages = this.logs.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)"400 HTTP GET error/400-no-body: No error entity detected.", (Object)messages.get(0));
    }

    @Test
    public void test500ErrorCodesWithBody() {
        this.target("/error/500").request().get();
        List<String> messages = this.logs.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)"500 HTTP GET error/500: Internal Server Error", (Object)messages.get(0));
    }

    @Test
    public void test500ErrorCodesNoBody() {
        this.target("/error/500-no-body").request().get();
        List<String> messages = this.logs.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)"500 HTTP GET error/500-no-body: No error entity detected.", (Object)messages.get(0));
    }

    @Path(value="/error")
    public static final class MockService {
        @GET
        @Path(value="/200")
        @Produces(value={"application/json"})
        public Response return200() {
            return Response.ok().build();
        }

        @GET
        @Path(value="/300")
        @Produces(value={"application/json"})
        public Response return300() throws Exception {
            return Response.seeOther((URI)new URI("https://example.com/")).build();
        }

        @GET
        @Path(value="/300-no-location")
        @Produces(value={"application/json"})
        public Response return300NoLocation() {
            return Response.status((int)300).build();
        }

        @GET
        @Path(value="/400")
        @Produces(value={"application/json"})
        public Response return400() {
            return ErrorResponseBuilder.from((Response.Status)Response.Status.BAD_REQUEST).build();
        }

        @GET
        @Path(value="/400-no-body")
        @Produces(value={"application/json"})
        public Response return400NoBody() {
            return Response.status((int)400).build();
        }

        @GET
        @Path(value="/500")
        @Produces(value={"application/json"})
        public Response return500() {
            return ErrorResponseBuilder.from((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }

        @GET
        @Path(value="/500-no-body")
        @Produces(value={"application/json"})
        public Response return500NoBody() {
            return Response.status((int)500).build();
        }
    }
}

