/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.logging;

import ch.qos.logback.classic.Level;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.jackson.JacksonFeature;
import net.krotscheck.kangaroo.common.logging.HttpResponseLoggingFilter;
import net.krotscheck.kangaroo.common.logging.LoggingFeature;
import net.krotscheck.kangaroo.test.LoggingRule;
import net.krotscheck.kangaroo.test.jersey.KangarooJerseyTest;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class LoggingFeatureTest
extends KangarooJerseyTest {
    @Rule
    public final LoggingRule logs = new LoggingRule(HttpResponseLoggingFilter.class, Level.ALL);

    @Before
    public void clearLogs() {
        this.logs.clear();
    }

    @Override
    protected ResourceConfig createApplication() {
        ResourceConfig config = new ResourceConfig();
        config.register(JacksonFeature.class);
        config.register(LoggingFeature.class);
        config.register(MockService.class);
        return config;
    }

    @Test
    public void test200ErrorCodes() {
        this.target("/error/200").request().get();
        List<String> messages = this.logs.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)"200 HTTP GET error/200", (Object)messages.get(0));
    }

    @Path(value="/error")
    public static final class MockService {
        @GET
        @Path(value="/200")
        @Produces(value={"application/json"})
        public Response return200() {
            return Response.ok().build();
        }
    }
}

