/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.response;

import java.util.ArrayList;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.response.ListResponseBuilder;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import net.krotscheck.kangaroo.common.response.SortOrder;
import org.junit.Assert;
import org.junit.Test;

public final class ListResponseBuilderTest {
    @Test
    public void testAddEntity() throws Exception {
        ArrayList entity = new ArrayList();
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.addResult(entity);
        Response response = b.build();
        ListResponseEntity e = (ListResponseEntity)response.getEntity();
        Assert.assertEquals(entity, (Object)e.getResults());
    }

    @Test
    public void testIntegerOffset() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.offset((Number)10);
        Response response = b.build();
        Assert.assertEquals((Object)"10", (Object)response.getHeaderString("Offset"));
    }

    @Test
    public void testLongOffset() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.offset((Number)10L);
        Response response = b.build();
        Assert.assertEquals((Object)"10", (Object)response.getHeaderString("Offset"));
    }

    @Test
    public void testShortOffset() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.offset((Number)10);
        Response response = b.build();
        Assert.assertEquals((Object)"10", (Object)response.getHeaderString("Offset"));
    }

    @Test
    public void testIntegerLimit() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.limit((Number)10);
        Response response = b.build();
        Assert.assertEquals((Object)"10", (Object)response.getHeaderString("Limit"));
    }

    @Test
    public void testLongLimit() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.limit((Number)10L);
        Response response = b.build();
        Assert.assertEquals((Object)"10", (Object)response.getHeaderString("Limit"));
    }

    @Test
    public void testShortLimit() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.limit((Number)10);
        Response response = b.build();
        Assert.assertEquals((Object)"10", (Object)response.getHeaderString("Limit"));
    }

    @Test
    public void testIntegerTotal() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.total((Number)10);
        Response response = b.build();
        Assert.assertEquals((Object)"10", (Object)response.getHeaderString("Total"));
    }

    @Test
    public void testObjectTotal() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.total((Object)10);
        Response response = b.build();
        Assert.assertEquals((Object)"10", (Object)response.getHeaderString("Total"));
    }

    @Test
    public void testLongTotal() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.total((Number)10L);
        Response response = b.build();
        Assert.assertEquals((Object)"10", (Object)response.getHeaderString("Total"));
    }

    @Test
    public void testShortTotal() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.total((Number)10);
        Response response = b.build();
        Assert.assertEquals((Object)"10", (Object)response.getHeaderString("Total"));
    }

    @Test
    public void testSort() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.sort("foo");
        Response response = b.build();
        Assert.assertEquals((Object)"foo", (Object)response.getHeaderString("Sort"));
    }

    @Test
    public void testSortOrderString() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.order("DESC");
        Response response = b.build();
        Assert.assertEquals((Object)"DESC", (Object)response.getHeaderString("Order"));
    }

    @Test
    public void testSortOrderEnum() throws Exception {
        ListResponseBuilder b = ListResponseBuilder.builder();
        b.order(SortOrder.DESC);
        Response response = b.build();
        Assert.assertEquals((Object)"DESC", (Object)response.getHeaderString("Order"));
    }

    @Test
    public void testSortFromString() throws Exception {
        Assert.assertEquals((Object)SortOrder.ASC, (Object)SortOrder.fromString((String)"ASC"));
        Assert.assertEquals((Object)SortOrder.DESC, (Object)SortOrder.fromString((String)"DESC"));
        Assert.assertEquals((Object)SortOrder.ASC, (Object)SortOrder.fromString((String)"invalid"));
    }

    @Test
    public void testSortToString() throws Exception {
        Assert.assertEquals((Object)"ASC", (Object)SortOrder.ASC.toString());
        Assert.assertEquals((Object)"DESC", (Object)SortOrder.DESC.toString());
    }
}

