/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.security;

import com.google.common.collect.Sets;
import javax.ws.rs.container.ContainerRequestContext;
import net.krotscheck.kangaroo.common.security.CsrfProtectionFilter;
import net.krotscheck.kangaroo.common.security.NoCSRFHeaderException;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class CsrfProtectionFilterTest {
    private ContainerRequestContext mockContext;

    @Before
    public void setUp() {
        this.mockContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
    }

    @Test
    public void assertIgnoresBasicMethods() {
        CsrfProtectionFilter filter = new CsrfProtectionFilter();
        Sets.newHashSet((Object[])new String[]{"GET", "OPTIONS", "HEAD"}).forEach(method -> {
            ((ContainerRequestContext)Mockito.doReturn((Object)method).when((Object)this.mockContext)).getMethod();
            filter.filter(this.mockContext);
        });
    }

    @Test(expected=NoCSRFHeaderException.class)
    public void assertFailsWithoutHeader() {
        CsrfProtectionFilter filter = new CsrfProtectionFilter();
        ((ContainerRequestContext)Mockito.doReturn((Object)"POST").when((Object)this.mockContext)).getMethod();
        MultivaluedStringMap map = new MultivaluedStringMap();
        ((ContainerRequestContext)Mockito.doReturn((Object)map).when((Object)this.mockContext)).getHeaders();
        filter.filter(this.mockContext);
    }

    @Test
    public void assertPassesWithHeader() {
        CsrfProtectionFilter filter = new CsrfProtectionFilter();
        ((ContainerRequestContext)Mockito.doReturn((Object)"POST").when((Object)this.mockContext)).getMethod();
        MultivaluedStringMap map = new MultivaluedStringMap();
        map.putSingle((Object)"X-Requested-With", (Object)"Test");
        ((ContainerRequestContext)Mockito.doReturn((Object)map).when((Object)this.mockContext)).getHeaders();
        filter.filter(this.mockContext);
    }
}

