/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.security;

import javax.ws.rs.BadRequestException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.security.NoCSRFHeaderException;
import org.junit.Assert;
import org.junit.Test;

public class NoCSRFHeaderExceptionTest {
    @Test
    public void testExtendsBadRequest() {
        NoCSRFHeaderException e = new NoCSRFHeaderException();
        Assert.assertTrue((boolean)(e instanceof BadRequestException));
    }

    @Test
    public void testCustomMessage() {
        NoCSRFHeaderException e = new NoCSRFHeaderException();
        Assert.assertEquals((Object)e.getMessage(), (Object)"No CSRF Header found, expected any value in X-Requested-With");
    }

    @Test
    public void testSerialization() {
        ErrorResponseBuilder.ErrorResponse e = ErrorResponseBuilder.from((WebApplicationException)new NoCSRFHeaderException()).buildEntity();
        Assert.assertEquals((Object)"No CSRF Header found, expected any value in X-Requested-With", (Object)e.getErrorDescription());
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)e.getHttpStatus());
        Assert.assertEquals((Object)"bad_request", (Object)e.getError());
    }
}

