/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.swagger;

import io.swagger.config.Scanner;
import io.swagger.jaxrs.config.SwaggerScannerLocator;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import net.krotscheck.kangaroo.common.swagger.SwaggerContainerLifecycleListener;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.spi.Container;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class SwaggerContainerLifecycleListenerTest {
    private InjectionManager injectionManager;
    private SwaggerContainerLifecycleListener listener;

    @Before
    public void setupLifecycleListener() {
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        ServletRegistration mockRegistration = (ServletRegistration)Mockito.mock(ServletRegistration.class);
        ((ServletContext)Mockito.doReturn((Object)"Name").when((Object)context)).getServletContextName();
        ((ServletContext)Mockito.doReturn((Object)mockRegistration).when((Object)context)).getServletRegistration("Name");
        ((ServletRegistration)Mockito.doReturn((Object)"ScannerId").when((Object)mockRegistration)).getInitParameter("swagger.context.id");
        ((ServletContext)Mockito.doReturn((Object)"/v1").when((Object)context)).getContextPath();
        this.injectionManager = (InjectionManager)Mockito.mock(InjectionManager.class);
        this.listener = new SwaggerContainerLifecycleListener("net.krotscheck.kangaroo");
        this.listener.setContext(context);
    }

    @Test
    public void getSetContext() {
        ServletContext mockContext = (ServletContext)Mockito.mock(ServletContext.class);
        Assert.assertNotSame((Object)mockContext, (Object)this.listener.getContext());
        this.listener.setContext(mockContext);
        Assert.assertSame((Object)mockContext, (Object)this.listener.getContext());
    }

    @Test
    public void onStartup() {
        Container container = (Container)Mockito.mock(Container.class);
        this.listener.onStartup(container);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{container});
        SwaggerScannerLocator locator = SwaggerScannerLocator.getInstance();
        Scanner scanner = locator.getScanner("ScannerId");
        Assert.assertNotNull((Object)scanner);
    }

    @Test
    public void onReload() {
        Container container = (Container)Mockito.mock(Container.class);
        this.listener.onReload(container);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{container});
    }

    @Test
    public void onShutdown() {
        Container container = (Container)Mockito.mock(Container.class);
        this.listener.onShutdown(container);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{container});
    }
}

