/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.swagger;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.swagger.SwaggerUIService;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;

public final class SwaggerUIServiceTest
extends ContainerTest {
    @Override
    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register(SwaggerUIService.class);
        return a;
    }

    @Test
    public void routeRootResource() throws Exception {
        Response r = this.target("/").request().get();
        Assert.assertEquals((long)200L, (long)r.getStatus());
        Assert.assertEquals((Object)"text", (Object)r.getMediaType().getType());
        Assert.assertEquals((Object)"html", (Object)r.getMediaType().getSubtype());
        r.bufferEntity();
        String body = (String)r.readEntity(String.class);
        String expectedBody = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("swagger/index.html"));
        Assert.assertEquals((Object)expectedBody, (Object)body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void routeAllResources() throws Exception {
        ClassLoader classLoader = SwaggerUIService.class.getClassLoader();
        InputStream dir = classLoader.getResourceAsStream("swagger");
        BufferedReader in = new BufferedReader(new InputStreamReader(dir));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                Response r = this.target(line).request().get();
                Assert.assertEquals((long)200L, (long)r.getStatus());
                r.bufferEntity();
                String body = (String)r.readEntity(String.class);
                String expectedBody = IOUtils.toString((InputStream)classLoader.getResourceAsStream(String.format("swagger/%s", line)));
                Assert.assertEquals((Object)expectedBody, (Object)body);
                r.close();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)dir);
        }
    }

    @Test
    public void routeErrorHandler() throws Exception {
        Response r = this.target("/invalid.html").request().get();
        Assert.assertEquals((long)404L, (long)r.getStatus());
    }
}

