/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.timedtasks;

import java.util.ArrayList;
import java.util.TimerTask;
import net.krotscheck.kangaroo.common.timedtasks.RepeatingTask;
import net.krotscheck.kangaroo.common.timedtasks.TimedTasksLifecycleListener;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.spi.Container;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class TimedTasksLifecycleListenerTest {
    private InjectionManager injectionManager;
    private TimedTasksLifecycleListener listener;

    @Before
    public void setupLifecycleListener() {
        this.injectionManager = (InjectionManager)Mockito.mock(InjectionManager.class);
        this.listener = new TimedTasksLifecycleListener(this.injectionManager);
    }

    @Test
    public void testBasicFunction() throws Exception {
        Container container = (Container)Mockito.mock(Container.class);
        ArrayList<TestTask> tasks = new ArrayList<TestTask>();
        TestTask one = new TestTask(100L);
        TestTask two = new TestTask(200L);
        tasks.add(one);
        tasks.add(two);
        ((InjectionManager)Mockito.doReturn(tasks).when((Object)this.injectionManager)).getAllInstances(RepeatingTask.class);
        this.listener.onStartup(container);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{container});
        Thread.sleep(250L);
        this.listener.onShutdown(container);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{container});
        Assert.assertEquals((long)one.getTickCount(), (long)2L);
        Assert.assertEquals((long)two.getTickCount(), (long)1L);
    }

    @Test
    public void onReload() {
        Container container = (Container)Mockito.mock(Container.class);
        this.listener.onReload(container);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{container});
    }

    public static final class TestTask
    extends TimerTask
    implements RepeatingTask {
        private final long period;
        private long tickCount = 0L;

        TestTask(long period) {
            this.period = period;
        }

        public long getTickCount() {
            return this.tickCount;
        }

        public TimerTask getTask() {
            return this;
        }

        public long getPeriod() {
            return this.period;
        }

        @Override
        public void run() {
            ++this.tickCount;
        }
    }
}

