/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.file.Paths;
import net.krotscheck.kangaroo.server.Config;
import org.junit.Assert;
import org.junit.Test;

public final class ConfigTest {
    @Test
    public void testPrivateConstructor() throws Exception {
        Constructor c = Config.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(c.getModifiers()));
        c.setAccessible(true);
        c.newInstance(new Object[0]);
    }

    @Test
    public void testConfigurationValues() {
        String currentWorkingPath = Paths.get(System.getProperty("user.home"), ".kangaroo").toAbsolutePath().normalize().toString();
        Assert.assertEquals((Object)"kangaroo.host", Config.HOST.getKey());
        Assert.assertEquals((Object)"127.0.0.1", Config.HOST.getValue());
        Assert.assertEquals((Object)"kangaroo.port", Config.PORT.getKey());
        Assert.assertEquals((Object)8080, Config.PORT.getValue());
        Assert.assertEquals((Object)"kangaroo.working_dir", Config.WORKING_DIR.getKey());
        Assert.assertEquals((Object)currentWorkingPath, Config.WORKING_DIR.getValue());
        Assert.assertEquals((Object)"kangaroo.keystore_path", Config.KEYSTORE_PATH.getKey());
        Assert.assertNull(Config.KEYSTORE_PATH.getValue());
        Assert.assertEquals((Object)"kangaroo.keystore_password", Config.KEYSTORE_PASS.getKey());
        Assert.assertEquals((Object)"kangaroo", Config.KEYSTORE_PASS.getValue());
        Assert.assertEquals((Object)"kangaroo.keystore_type", Config.KEYSTORE_TYPE.getKey());
        Assert.assertEquals((Object)"PKCS12", Config.KEYSTORE_TYPE.getValue());
        Assert.assertEquals((Object)"kangaroo.cert_alias", Config.CERT_ALIAS.getKey());
        Assert.assertEquals((Object)"kangaroo", Config.CERT_ALIAS.getValue());
        Assert.assertEquals((Object)"kangaroo.cert_key_password", Config.CERT_KEY_PASS.getKey());
        Assert.assertEquals((Object)"kangaroo", Config.CERT_KEY_PASS.getValue());
        Assert.assertEquals((Object)"kangaroo.html_app_root", Config.HTML_APP_ROOT.getKey());
        Assert.assertNull(Config.HTML_APP_ROOT.getValue());
    }
}

