/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import net.krotscheck.kangaroo.server.Config;
import net.krotscheck.kangaroo.server.ConfigurationBuilder;
import net.krotscheck.kangaroo.server.ServerFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class ConfigurationBuilderTest {
    @Test
    public void addCommandlineArgs() {
        Configuration config = new ConfigurationBuilder().withCommandlineOptions(ServerFactory.CLI_OPTIONS).addCommandlineArgs(new String[]{"-h=example.com", "-p=9000", "--kangaroo.working_dir=/opt/kangaroo", "--kangaroo.keystore_path=/foo/bar", "--kangaroo.keystore_password=keystore_password", "--kangaroo.keystore_type=JKS", "--kangaroo.cert_alias=cert_alias", "--kangaroo.cert_key_password=key_password", "--kangaroo.html_app_root=/var/www"}).build();
        Assert.assertEquals((Object)config.getString((String)Config.HOST.getKey()), (Object)"example.com");
        Assert.assertEquals((long)config.getInt((String)Config.PORT.getKey()), (long)9000L);
        Assert.assertEquals((Object)config.getString((String)Config.WORKING_DIR.getKey()), (Object)"/opt/kangaroo");
        Assert.assertEquals((Object)config.getString((String)Config.KEYSTORE_PATH.getKey()), (Object)"/foo/bar");
        Assert.assertEquals((Object)config.getString((String)Config.KEYSTORE_PASS.getKey()), (Object)"keystore_password");
        Assert.assertEquals((Object)config.getString((String)Config.KEYSTORE_TYPE.getKey()), (Object)"JKS");
        Assert.assertEquals((Object)config.getString((String)Config.CERT_ALIAS.getKey()), (Object)"cert_alias");
        Assert.assertEquals((Object)config.getString((String)Config.CERT_KEY_PASS.getKey()), (Object)"key_password");
        Assert.assertEquals((Object)config.getString((String)Config.HTML_APP_ROOT.getKey()), (Object)"/var/www");
    }

    @Test(expected=RuntimeException.class)
    public void addInvalidCommandlineArgs() {
        new ConfigurationBuilder().withCommandlineOptions(ServerFactory.CLI_OPTIONS).addCommandlineArgs(new String[]{"-l=invalid_field"}).build();
    }

    @Test
    public void addNoCommandlineArgs() {
        Configuration config = new ConfigurationBuilder().withCommandlineOptions(ServerFactory.CLI_OPTIONS).addCommandlineArgs(new String[0]).build();
        Assert.assertNull((Object)config.getString((String)Config.HOST.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.PORT.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.WORKING_DIR.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.KEYSTORE_PATH.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.KEYSTORE_PASS.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.KEYSTORE_TYPE.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.CERT_ALIAS.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.CERT_KEY_PASS.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.HTML_APP_ROOT.getKey()));
    }

    @Test
    public void addWithDefaults() {
        HashMap defaults = new HashMap();
        defaults.put(Config.HOST.getKey(), "example.com");
        defaults.put(Config.PORT.getKey(), "1000");
        defaults.put(Config.WORKING_DIR.getKey(), "/foo/bar");
        Configuration config = new ConfigurationBuilder().withDefaults(defaults).withCommandlineOptions(ServerFactory.CLI_OPTIONS).addCommandlineArgs(new String[0]).build();
        Assert.assertEquals((Object)"example.com", (Object)config.getString((String)Config.HOST.getKey()));
        Assert.assertEquals((long)1000L, (long)config.getInt((String)Config.PORT.getKey()));
        Assert.assertEquals((Object)"/foo/bar", (Object)config.getString((String)Config.WORKING_DIR.getKey()));
    }

    @Test
    public void addPropertiesFile() {
        URL filePath = this.getClass().getResource("/config/test.properties");
        Configuration config = new ConfigurationBuilder().withCommandlineOptions(ServerFactory.CLI_OPTIONS).addPropertiesFile(filePath.getPath()).build();
        Assert.assertEquals((Object)config.getString((String)Config.HOST.getKey()), (Object)"example.com");
        Assert.assertEquals((long)config.getInt((String)Config.PORT.getKey()), (long)9000L);
        Assert.assertEquals((Object)config.getString((String)Config.WORKING_DIR.getKey()), (Object)"/opt/kangaroo");
        Assert.assertEquals((Object)config.getString((String)Config.KEYSTORE_PATH.getKey()), (Object)"/foo/bar");
        Assert.assertEquals((Object)config.getString((String)Config.KEYSTORE_PASS.getKey()), (Object)"keystore_password");
        Assert.assertEquals((Object)config.getString((String)Config.KEYSTORE_TYPE.getKey()), (Object)"JKS");
        Assert.assertEquals((Object)config.getString((String)Config.CERT_ALIAS.getKey()), (Object)"cert_alias");
        Assert.assertEquals((Object)config.getString((String)Config.CERT_KEY_PASS.getKey()), (Object)"key_password");
        Assert.assertEquals((Object)config.getString((String)Config.HTML_APP_ROOT.getKey()), (Object)"/var/www");
    }

    @Test
    public void addNonexistentPropertiesFile() {
        Configuration config = new ConfigurationBuilder().withCommandlineOptions(ServerFactory.CLI_OPTIONS).addPropertiesFile("/config/nonexistent.properties").build();
        Assert.assertNull((Object)config.getString((String)Config.HOST.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.PORT.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.WORKING_DIR.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.KEYSTORE_PATH.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.KEYSTORE_PASS.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.KEYSTORE_TYPE.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.CERT_ALIAS.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.CERT_KEY_PASS.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.HTML_APP_ROOT.getKey()));
    }

    @Test
    public void addMalformedPropertiesFile() throws Exception {
        File mockConfigFile = (File)Mockito.mock(File.class);
        ((File)Mockito.doReturn((Object)true).when((Object)mockConfigFile)).exists();
        Configuration config = new ConfigurationBuilder().withCommandlineOptions(ServerFactory.CLI_OPTIONS).addPropertiesFile(mockConfigFile).build();
        Assert.assertNull((Object)config.getString((String)Config.HOST.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.PORT.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.WORKING_DIR.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.KEYSTORE_PATH.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.KEYSTORE_PASS.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.KEYSTORE_TYPE.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.CERT_ALIAS.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.CERT_KEY_PASS.getKey()));
        Assert.assertNull((Object)config.getString((String)Config.HTML_APP_ROOT.getKey()));
    }

    @Test
    public void testSystemParameters() {
        Configuration config = new ConfigurationBuilder().withCommandlineOptions(ServerFactory.CLI_OPTIONS).build();
        SystemConfiguration c = new SystemConfiguration();
        Iterator iterator = c.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Assert.assertEquals((Object)config.getString(key), (Object)c.getString(key));
        }
    }

    @Test
    public void testEnvParameters() {
        Configuration config = new ConfigurationBuilder().withCommandlineOptions(ServerFactory.CLI_OPTIONS).build();
        EnvironmentConfiguration c = new EnvironmentConfiguration();
        Iterator iterator = c.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Assert.assertEquals((Object)config.getString(key), (Object)c.getString(key));
        }
    }
}

